# Getting Started with the CycloneBOOT Repository

## Folder Structure

```plaintext

    demo
      ├── microchip
      │   └── same54_xplained_pro
      │       ├── hybrid_app_bl
      │       └── iap_dual_bank
      └── st
          ├── nucleo_f429zi
          │   └── iap_dual_bank
          ├── nucleo_f767zi
          │   └── iap_dual_bank
          ├── nucleo_h563zi
          │   ├── hybrid_app_bl
          │   └── iap_dual_bank
          ├── nucleo_h743zi2
          │   ├── hybrid_app_bl
          │   └── iap_dual_bank
          ├── nucleo_h7a3zi_q
          │   └── iap_dual_bank
          ├── nucleo_l476rg
          │   └── hybrid_app_bl
          ├── nucleo_l496zg
          │   └── iap_dual_bank
          ├── nucleo_u575zi_q
          │   └── iap_dual_bank
          ├── stm32429i_eval
          │   ├── hybrid_app_bl
          │   └── iap_dual_bank
          ├── stm32f769i_discovery
          │   ├── hybrid_app_bl
          │   └── iap_dual_bank
          ├── stm32f769i_eval
          │   ├── hybrid_app_bl
          │   └── iap_dual_bank
          ├── stm32h573i_dk
          │   └── hybrid_app_bl
          ├── stm32h750b_discovery
          │   └── standalone_bl
          └── stm32h753i_eval2
              ├── hybrid_app_bl
              └── iap_dual_bank

  src
      ├── common
      ├── cyclone_boot
      ├── cyclone_crypto
      ├── cyclone_ssh
      ├── cyclone_ssl
      └── cyclone_tcp

  third_party
      ├── cmsis
      ├── freertos
      ├── microchip
      ├── st
      └── tinyusb

  tools
      ├── ImageBuilder
      └── ResourceCompiler

```

## Folder Descriptions

### `demo/`

Contains ready-to-use demonstration projects for supported evaluation boards. Projects are organized by hardware vendor and then by board.

Each board includes multiple _firmware update scenarios_ for different types of flash memory architecture:

- Internal and/or External Flash with a 2nd stage bootloader to manage the update (`hybrid_app_bl`). The application is responsible for downloading the firmware update over the specified protocol (e.g., HTTP, SFTP, MQTT)
- Internal and/or External Flash with a standalone bootloader to manage the update (`standlone_bl`). The bootloader includes the protocol library to fetch the firmware, much like the application firmware in the previous architecture. This configuration removes the dependency of the firmware application to the bootloader to fetch the firmware update. It also allows advanced operation modes such as eXecute In Place (XiP)
- Internal Flash in "Dual Bank/Dual Parition" architecture not requiring a 2nd stage bootloader (`iap_dual_bank`). In this instance, firmware will download and install the firmware update to an available partition, without requiring explicit input from a bootloader

> Refer to the `README.md` inside each demo project folder for more details. For `hybrid_app_bl` demo projects, the bootloader operation is covered by the README.md file present in the application demo folder.

---

### `src/`

Contains the main source code for **CycloneBOOT** and other **Oryx Embedded** middleware:

- `cyclone_boot` and `cyclone_crypto`: Core components of the CycloneBOOT system.
- Other folders (e.g., `cyclone_tcp`, `cyclone_ssh`) provide protocol support for demos.

---

### `third_party/`

Contains vendor libraries and middleware dependencies:

- CMSIS and HAL drivers from vendors such as STMicroelectronics
- FreeRTOS
- Board Support Packages (BSPs)
- Other middleware libraries used in demonstration projects
- Etc.

---

### `tools/`

Includes utilities used by the demos:

- **ImageBuilder**
  Creates firmware update images compatible with CycloneBOOT.
  Pre-built binaries are available for Windows and Linux in `ImageBuilder/bin`.

- **ResourceCompiler**
  Converts files like `.pem` keys and `.html` pages into C arrays.
  These resources simulate a basic filesystem within demos.
  Pre-built binaries are available for Windows and Linux in `ResourceCompiler/bin`.
  Resource files can be found in the `resources/` folder of each demo project.

---

## Contact

For support or questions, contact the development team at:

**info@oryx-embedded.com**
