/**
 * @file boot_config.h
 * @brief CycloneBOOT configuration file
 *
 * @section License
 *
 * Copyright (C) 2021-2026 Oryx Embedded SARL. All rights reserved.
 * 
 * This software is provided in source form for a short-term evaluation only. The
 * evaluation license expires 90 days after the date you first download the software.
 *
 * If you plan to use this software in a commercial product, you are required to
 * purchase a commercial license from Oryx Embedded SARL.
 *
 * After the 90-day evaluation period, you agree to either purchase a commercial
 * license or delete all copies of this software. If you wish to extend the
 * evaluation period, you must contact sales@oryx-embedded.com.
 *
 * This evaluation software is provided "as is" without warranty of any kind.
 * Technical support is available as an option during the evaluation period.

 *
 * @author Oryx Embedded SARL (www.oryx-embedded.com)
 * @version 2.6.0
 **/

#ifndef _BOOT_CONFIG_H
#define _BOOT_CONFIG_H

//Trace level for CycloneBOOT stack debugging
#define CBOOT_TRACE_LEVEL TRACE_LEVEL_INFO
#define CBOOT_DRIVER_TRACE_LEVEL TRACE_LEVEL_INFO

//Number of memories used
// #define NB_MEMORIES 1
#define NB_MEMORIES 2 //because of external memory use
//Number of slots within the memory
#define NB_MAX_MEMORY_SLOTS 3
//External memory support
#define EXTERNAL_MEMORY_SUPPORT ENABLED//DISABLED

//Update Single Bank Mode support
#define UPDATE_SINGLE_BANK_SUPPORT ENABLED
//Update Dual Bank Mode support
#define UPDATE_DUAL_BANK_SUPPORT DISABLED
//Update Anti-Rollback support
#define UPDATE_ANTI_ROLLBACK_SUPPORT DISABLED

//Cipher support
#define CIPHER_SUPPORT DISABLED
//Image input encrypted
#define IMAGE_INPUT_ENCRYPTED DISABLED
//Image output encrypted
#define IMAGE_OUTPUT_ENCRYPTED DISABLED
//Verification Integrity support
#define VERIFY_INTEGRITY_SUPPORT ENABLED
//Verification Signture support
#define VERIFY_SIGNATURE_SUPPORT DISABLED
//Verification RSA signture algo support
#define VERIFY_RSA_SUPPORT DISABLED


#endif //!_BOOT_CONFIG_H
