/**
 * @file crypto_config.h
 * @brief CycloneCRYPTO configuration file
 *
 * @section License
 *
 * Copyright (C) 2021-2026 Oryx Embedded SARL. All rights reserved.
 * 
 * This software is provided in source form for a short-term evaluation only. The
 * evaluation license expires 90 days after the date you first download the software.
 *
 * If you plan to use this software in a commercial product, you are required to
 * purchase a commercial license from Oryx Embedded SARL.
 *
 * After the 90-day evaluation period, you agree to either purchase a commercial
 * license or delete all copies of this software. If you wish to extend the
 * evaluation period, you must contact sales@oryx-embedded.com.
 *
 * This evaluation software is provided "as is" without warranty of any kind.
 * Technical support is available as an option during the evaluation period.

 *
 * @author Oryx Embedded SARL (www.oryx-embedded.com)
 * @version 2.6.0
 **/

#ifndef _CRYPTO_CONFIG_H
#define _CRYPTO_CONFIG_H

//Desired trace level (for debugging purposes)
#define CRYPTO_TRACE_LEVEL TRACE_LEVEL_INFO

//True random number generator
#define STM32H5XX_CRYPTO_TRNG_SUPPORT ENABLED
//Hash hardware accelerator
#define STM32H5XX_CRYPTO_HASH_SUPPORT ENABLED
//Cipher hardware accelerator
#define STM32H5XX_CRYPTO_CIPHER_SUPPORT ENABLED
//Public-key hardware accelerator
#define STM32H5XX_CRYPTO_PKC_SUPPORT ENABLED

//Multiple precision integer support
#define MPI_SUPPORT ENABLED
//Assembly optimizations for time-critical routines
#define MPI_ASM_SUPPORT DISABLED

//Base64 encoding support
#define BASE64_SUPPORT ENABLED
//Base64url encoding support
#define BASE64URL_SUPPORT DISABLED

//MD2 support
#define MD2_SUPPORT DISABLED
//MD4 support
#define MD4_SUPPORT DISABLED
//MD5 support
#define MD5_SUPPORT ENABLED
//RIPEMD-128 support
#define RIPEMD128_SUPPORT DISABLED
//RIPEMD-160 support
#define RIPEMD160_SUPPORT DISABLED
//SHA-1 support
#define SHA1_SUPPORT ENABLED
//SHA-224 support
#define SHA224_SUPPORT ENABLED
//SHA-256 support
#define SHA256_SUPPORT ENABLED
//SHA-384 support
#define SHA384_SUPPORT ENABLED
//SHA-512 support
#define SHA512_SUPPORT ENABLED
//SHA-512/224 support
#define SHA512_224_SUPPORT DISABLED
//SHA-512/256 support
#define SHA512_256_SUPPORT DISABLED
//SHA3-224 support
#define SHA3_224_SUPPORT DISABLED
//SHA3-256 support
#define SHA3_256_SUPPORT DISABLED
//SHA3-384 support
#define SHA3_384_SUPPORT DISABLED
//SHA3-512 support
#define SHA3_512_SUPPORT DISABLED
//Ascon-Hash256 support
#define ASCON_HASH256_SUPPORT DISABLED
//BLAKE2b-160 support
#define BLAKE2B160_SUPPORT DISABLED
//BLAKE2b-256 support
#define BLAKE2B256_SUPPORT DISABLED
//BLAKE2b-384 support
#define BLAKE2B384_SUPPORT DISABLED
//BLAKE2b-512 support
#define BLAKE2B512_SUPPORT DISABLED
//BLAKE2s-128 support
#define BLAKE2S128_SUPPORT DISABLED
//BLAKE2s-160 support
#define BLAKE2S160_SUPPORT DISABLED
//BLAKE2s-224 support
#define BLAKE2S224_SUPPORT DISABLED
//BLAKE2s-256 support
#define BLAKE2S256_SUPPORT DISABLED
//SM3 support
#define SM3_SUPPORT DISABLED
//Tiger support
#define TIGER_SUPPORT DISABLED
//Whirlpool support
#define WHIRLPOOL_SUPPORT DISABLED

//Keccak support
#define KECCAK_SUPPORT DISABLED
//SHAKE support
#define SHAKE_SUPPORT DISABLED
//cSHAKE support
#define CSHAKE_SUPPORT DISABLED
//Ascon-XOF128 support
#define ASCON_XOF128_SUPPORT DISABLED
//Ascon-CXOF128 support
#define ASCON_CXOF128_SUPPORT DISABLED

//CMAC support
#define CMAC_SUPPORT DISABLED
//HMAC support
#define HMAC_SUPPORT ENABLED
//GMAC support
#define GMAC_SUPPORT DISABLED
//KMAC support
#define KMAC_SUPPORT DISABLED
//XCBC-MAC support
#define XCBC_MAC_SUPPORT DISABLED
//BLAKE2b support
#define BLAKE2B_SUPPORT DISABLED
//BLAKE2s support
#define BLAKE2S_SUPPORT DISABLED
//Poly1305 support
#define POLY1305_SUPPORT ENABLED

//RC2 support
#define RC2_SUPPORT DISABLED
//RC4 support
#define RC4_SUPPORT DISABLED
//RC6 support
#define RC6_SUPPORT DISABLED
//CAST-128 support
#define CAST128_SUPPORT DISABLED
//CAST-256 support
#define CAST256_SUPPORT DISABLED
//IDEA support
#define IDEA_SUPPORT DISABLED
//DES support
#define DES_SUPPORT DISABLED
//Triple DES support
#define DES3_SUPPORT DISABLED
//AES support
#define AES_SUPPORT ENABLED
//Blowfish support
#define BLOWFISH_SUPPORT DISABLED
//Twofish support
#define TWOFISH_SUPPORT DISABLED
//MARS support
#define MARS_SUPPORT DISABLED
//Serpent support
#define SERPENT_SUPPORT DISABLED
//Camellia support
#define CAMELLIA_SUPPORT DISABLED
//ARIA support
#define ARIA_SUPPORT DISABLED
//SEED support
#define SEED_SUPPORT DISABLED
//SM4 support
#define SM4_SUPPORT DISABLED
//PRESENT support
#define PRESENT_SUPPORT DISABLED
//TEA support
#define TEA_SUPPORT DISABLED
//XTEA support
#define XTEA_SUPPORT DISABLED
//ChaCha support
#define CHACHA_SUPPORT ENABLED
//Salsa20 support
#define SALSA20_SUPPORT DISABLED
//Trivium support
#define TRIVIUM_SUPPORT DISABLED
//ZUC support
#define ZUC_SUPPORT DISABLED

//ECB mode support
#define ECB_SUPPORT DISABLED
//CBC mode support
#define CBC_SUPPORT ENABLED
//CFB mode support
#define CFB_SUPPORT DISABLED
//OFB mode support
#define OFB_SUPPORT DISABLED
//CTR mode support
#define CTR_SUPPORT DISABLED
//XTS mode support
#define XTS_SUPPORT DISABLED
//CCM mode support
#define CCM_SUPPORT ENABLED
//GCM mode support
#define GCM_SUPPORT ENABLED
//SIV mode support
#define SIV_SUPPORT DISABLED

//Ascon-AEAD128 support
#define ASCON_AEAD128_SUPPORT DISABLED
//ChaCha20Poly1305 support
#define CHACHA20_POLY1305_SUPPORT ENABLED

//Diffie-Hellman support
#define DH_SUPPORT ENABLED
//RSA support
#define RSA_SUPPORT ENABLED
//DSA support
#define DSA_SUPPORT ENABLED

//Elliptic curve cryptography support
#define EC_SUPPORT ENABLED
//ECDH support
#define ECDH_SUPPORT ENABLED
//ECDSA support
#define ECDSA_SUPPORT ENABLED

//secp112r1 elliptic curve support
#define SECP112R1_SUPPORT DISABLED
//secp112r2 elliptic curve support
#define SECP112R2_SUPPORT DISABLED
//secp128r1 elliptic curve support
#define SECP128R1_SUPPORT DISABLED
//secp128r2 elliptic curve support
#define SECP128R2_SUPPORT DISABLED
//secp160k1 elliptic curve support
#define SECP160K1_SUPPORT DISABLED
//secp160r1 elliptic curve support
#define SECP160R1_SUPPORT DISABLED
//secp160r2 elliptic curve support
#define SECP160R2_SUPPORT DISABLED
//secp192k1 elliptic curve support
#define SECP192K1_SUPPORT DISABLED
//secp192r1 elliptic curve support (NIST P-192)
#define SECP192R1_SUPPORT DISABLED
//secp224k1 elliptic curve support
#define SECP224K1_SUPPORT DISABLED
//secp224r1 elliptic curve support (NIST P-224)
#define SECP224R1_SUPPORT ENABLED
//secp256k1 elliptic curve support
#define SECP256K1_SUPPORT DISABLED
//secp256r1 elliptic curve support (NIST P-256)
#define SECP256R1_SUPPORT ENABLED
//secp384r1 elliptic curve support (NIST P-384)
#define SECP384R1_SUPPORT ENABLED
//secp521r1 elliptic curve support (NIST P-521)
#define SECP521R1_SUPPORT ENABLED
//brainpoolP160r1 elliptic curve support
#define BRAINPOOLP160R1_SUPPORT DISABLED
//brainpoolP192r1 elliptic curve support
#define BRAINPOOLP192R1_SUPPORT DISABLED
//brainpoolP224r1 elliptic curve support
#define BRAINPOOLP224R1_SUPPORT DISABLED
//brainpoolP256r1 elliptic curve support
#define BRAINPOOLP256R1_SUPPORT DISABLED
//brainpoolP320r1 elliptic curve support
#define BRAINPOOLP320R1_SUPPORT DISABLED
//brainpoolP384r1 elliptic curve support
#define BRAINPOOLP384R1_SUPPORT DISABLED
//brainpoolP512r1 elliptic curve support
#define BRAINPOOLP512R1_SUPPORT DISABLED
//FRP256v1 elliptic curve support
#define FRP256V1_SUPPORT DISABLED
//SM2 elliptic curve support
#define SM2_SUPPORT DISABLED
//Curve25519 elliptic curve support
#define X25519_SUPPORT ENABLED
//Curve448 elliptic curve support
#define X448_SUPPORT DISABLED
//Ed25519 elliptic curve support
#define ED25519_SUPPORT DISABLED
//Ed448 elliptic curve support
#define ED448_SUPPORT DISABLED

//Key encapsulation mechanism support
#define KEM_SUPPORT DISABLED

//ML-KEM-512 support
#define MLKEM512_SUPPORT DISABLED
//ML-KEM-768 support
#define MLKEM768_SUPPORT DISABLED
//ML-KEM-1024 support
#define MLKEM1024_SUPPORT DISABLED
//Streamlined NTRU Prime 761 support
#define SNTRUP761_SUPPORT DISABLED

//HKDF support
#define HKDF_SUPPORT ENABLED
//PBKDF support
#define PBKDF_SUPPORT DISABLED
//bcrypt support
#define BCRYPT_SUPPORT DISABLED
//scrypt support
#define SCRYPT_SUPPORT DISABLED
//MD5-crypt support
#define MD5_CRYPT_SUPPORT DISABLED
//SHA-crypt support
#define SHA_CRYPT_SUPPORT DISABLED

//PKCS #5 support
#define PKCS5_SUPPORT DISABLED
//PKCS #7 support
#define PKCS7_SUPPORT DISABLED

//Hash_DRBG PRNG support
#define HASH_DRBG_SUPPORT DISABLED
//HMAC_DRBG PRNG support
#define HMAC_DRBG_SUPPORT ENABLED
//CTR_DRBG PRNG support
#define CTR_DRBG_SUPPORT DISABLED
//XDRBG PRNG support
#define XDRBG_SUPPORT DISABLED

#endif
