# CycloneBOOT Quick Start Guide

This guide explains how to perform secure firmware updates on an MCU using CycloneBOOT.

In the "standalone_bl" configuration, the bootloader manages the full firmware update process including reception, validation and installation. Therefore, the bootloader includes a predefined protocol.

| Memory Section | Description           |
| -------------- | --------------------- |
| Bootloader     | Standalone Bootloader |
| Application    | Application firmware  |

The internal flash typically stores the bootloader, and the application firmware.

_Note_: Some MCU families provide a small internal flash for storing the bootloader and a large external flash for the application. This configuration, known as eXecute In Place (XiP), is supported by CycloneBOOT using this "standalone_bl" configuration.

**Update Flow**: New firmware is received via a predefined protocol, validated, and installed over the existing application firmware. The bootloader will then jump to the firmware application upon successful installation. In addition, the firmware application can request an update using the push button available on the chosen evaluation board.

---

## Prerequisites

1. A flashing/programming tool. Refer to the Flashing & Programming section for more information
2. **CycloneBOOT ImageBuilder** – Located in `tools/ImageBuilder/bin/`. Packages firmware, adds metadata, and applies encryption/signatures if required
3. **Python 3.0+** – Required for some post-build hooks: <https://www.python.org/downloads/>
4. Client/host software to transfer the encrypted and signed update image to the device. Refer to the Protocol section for more information
5. Terminal emulator (Windows Terminal, PowerShell, Bash, etc.)

---

### Flashing & Programming

Flashing/programming depends on the MCU vendor of the chosen demo project. Typically, there are a few options:

- **STM32CubeIDE or STM32CubeProgrammer** (compatible with STM32 MCUs). The commands to use this tool are available in the comment block in `src/main.c` of the chosen demo project
- **J-Link, ST-Link, etc.** Since there are many tools and options available, the comment block in `src/main.c` of the chosen demo project will indicate the address and any special options (depending on the MCU) that must be configured when flashing the firmware

---

### Protocol

CycloneBOOT is protocol-agnostic. However, for easier evaluation, demo projects in this repository use common protocols such as HTTP, FTP, or UART. Depending on the chosen protocol, the user may need to use a different tool (e.g., a web browser, FTP/SFTP client, serial terminal emulator, etc.). Below is a summary of tools used across available demo projects. Any specific parameters required will be noted in the comment block in `src/main.c` of the chosen demo project.

- **HTTP**: Web browser is used to upload the firmware update
- **SFTP/FTP**: FileZilla FTP client is used to upload the firmware update
- **UART/Y-Modem**: Tera Term is used on Windows; on Linux, many Y-Modem implementations are available
- **MQTT**: A custom Python script using the `paho-mqtt` library from Pip

---

## 1. Configure Board

- Ensure the MCU is configured so that the internal flash is treated as a contiguous memory block. Refer to the comment block in `src/main.c` of your chosen demo project for more information
- Erase the internal flash before proceeding further

---

## 2a. Standalone Bootloader

### Build Standalone Bootloader

1. Open `standalone_bl/standalone_bl_<protocol_config>/` using a supported toolchain/IDE
2. Build → generates `bootloader.bin`

### Flash Bootloader

- Using a programming/flashing tool, flash the standalone bootloader to the MCU internal flash. The exact address depends on the MCU vendor. Refer to the comment block in `src/main.c` of your chosen demo project for more information

---

## 3. Build & Flash Initial Firmware (v1.0.0)

1. Open `standalone_bl/app_blinky/` using a supported toolchain/IDE
2. Check `src/version.h` → default `1.0.0`
3. Build → generates `blinky_1_0_0.bin`
4. Package the binary from the previous step with the ImageBuilder CLI tool:

```cmd
   image_builder_windows.exe --input blinky_1_0_0.bin --output blinky_1_0_0_bootable.bin --integrity-algo crc32 --vtor-align
```

5. Flash the resulting `blinky_1_0_0_bootable.bin` to the MCU internal flash using a programming/flashing tool. The exact address is available in the `src/main.c` comment block

## 4. Build & Generate Firmware Update (v2.0.0)

1. Update `app_blinky/src/version.h` → `2.0.0`
2. Build the project again → generates `blinky_2_0_0.bin`
3. Package this binary with ImageBuilder to generate a firmware image compatible with the standalone bootloader:

```cmd
image_builder_windows.exe --input blinky_2_0_0.bin --output blinky_2_0_0.img --enc-algo aes-cbc --enc-key aa3ff7d43cc015682c7dfd00de9379e7 --sign-algo rsa-sha256 --sign-key .\\resources\\keys\\rsa_private_key.pem --vtor-align
```

## 5. Triggering a Firmware Update

By default, upon MCU reset, if the current application firmware is valid, the standalone bootloader will jump to the firmware application. To perform a firmware update, the bootloader must remain active without progressing further. This can be done in two ways:

- During MCU reset, briefly press the user push button on the evaluation board (see src/main.c for details). This triggers the bootloader to wait for a firmware update
- While the firmware application is running, press the user push button. This sends a message to the bootloader to wait for a firmware update on the next reset

## 6. Upload the Firmware Update

Refer to the `src/main.c` comment block for more information about the required tools and configuration steps.
