/**
 * @file boot_config.h
 * @brief Generic module description
 *
 * @section License
 *
 * Copyright (C) 2021-2026 Oryx Embedded SARL. All rights reserved.
 * 
 * This software is provided in source form for a short-term evaluation only. The
 * evaluation license expires 90 days after the date you first download the software.
 *
 * If you plan to use this software in a commercial product, you are required to
 * purchase a commercial license from Oryx Embedded SARL.
 *
 * After the 90-day evaluation period, you agree to either purchase a commercial
 * license or delete all copies of this software. If you wish to extend the
 * evaluation period, you must contact sales@oryx-embedded.com.
 *
 * This evaluation software is provided "as is" without warranty of any kind.
 * Technical support is available as an option during the evaluation period.

 *
 * @author Oryx Embedded SARL (www.oryx-embedded.com)
 * @version 2.6.0
 **/

//
// Created by danan on 2/14/2025.
//

#ifndef BOOT_CONFIG_H
#define BOOT_CONFIG_H

//Bootloader trace level
#define BOOT_TRACE_LEVEL 4

//Number of memory to be used
#define NB_MEMORIES 1

//Number of slots within the memory
#define NB_MAX_MEMORY_SLOTS 1

#define UPDATE_SINGLE_BANK_SUPPORT ENABLED
#define UPDATE_DUAL_BANK_SUPPORT DISABLED

//External memory support
#define EXTERNAL_MEMORY_SUPPORT DISABLED

//Anti-Rollback support
#define UPDATE_ANTI_ROLLBACK_SUPPORT DISABLED

//Fallback support
#define UPDATE_FALLBACK_SUPPORT DISABLED

//Cipher support
#define CIPHER_SUPPORT ENABLED
//Image input encrypted
#define IMAGE_INPUT_ENCRYPTED ENABLED
//Verification Integrity support
#define VERIFY_INTEGRITY_SUPPORT ENABLED
//Verification Signture support
#define VERIFY_SIGNATURE_SUPPORT ENABLED
//Verification RSA signture algo support
#define VERIFY_RSA_SUPPORT ENABLED

//Experimental configurations
#define BOOT_XIP_SUPPORT            ENABLED
#define UPDATE_STANDALONE_BOOT_MODE ENABLED

#endif //BOOT_CONFIG_H
