/**
 * @file boot.h
 * @brief CycloneBOOT 1st Stage Bootloader managment
 *
 * @section License
 *
 * Copyright (C) 2021-2026 Oryx Embedded SARL. All rights reserved.
 *
 * This file is part of CycloneBOOT Eval
 * 
 * This software is provided in source form for a short-term evaluation only. The
 * evaluation license expires 90 days after the date you first download the software.
 *
 * If you plan to use this software in a commercial product, you are required to
 * purchase a commercial license from Oryx Embedded SARL.
 *
 * After the 90-day evaluation period, you agree to either purchase a commercial
 * license or delete all copies of this software. If you wish to extend the
 * evaluation period, you must contact sales@oryx-embedded.com.
 *
 * This evaluation software is provided "as is" without warranty of any kind.
 * Technical support is available as an option during the evaluation period.

 *
 * @author Oryx Embedded SARL (www.oryx-embedded.com)
 * @version 2.6.0
 **/

#ifndef _BOOT_H
#define _BOOT_H

#include "core/flash.h"
#include "core/cboot_error.h"
#include "debug.h"

typedef struct {
   const FlashDriver *driver;
   uintptr_t address;  //Address of second stage bl
   uint32_t offset;
   uint32_t *slots;
   size_t slot_count;
   uintptr_t update_address;  //Address of the slot containing bl update
} BootContext;

cboot_error_t bootFsm(BootContext *context);

cboot_error_t checkSecondStageBlIntegrity(BootContext *context);
bool_t checkForSecondStageBlUpdate(BootContext *context);
cboot_error_t updateSecondStageBl(BootContext *context);
void jumpToSecondStageBl(BootContext *context);

#if ((defined(__ARMCC_VERSION) && (__ARMCC_VERSION >= 6010050)) || defined(__GNUC__) ||            \
   defined(__CC_ARM) || defined(__IAR_SYSTEMS_ICC__) || defined(__TASKING__) ||                  \
   defined(__CWCC__) || defined(__TI_ARM__))
void bootHandleError(void);
#elif ((defined(_MSC_VER) || defined(_WIN32) || defined(WIN32) || defined(WIN64) ||                \
   defined(__unix__)))
extern void bootHandleError(void);
#endif

#endif
