/**
 * @file boot_secure.h
 * @brief CycloneBOOT Bootloader Secure Boot related functions
 *
 * @section License
 *
 * Copyright (C) 2021-2026 Oryx Embedded SARL. All rights reserved.
 *
 * This file is part of CycloneBOOT Eval
 * 
 * This software is provided in source form for a short-term evaluation only. The
 * evaluation license expires 90 days after the date you first download the software.
 *
 * If you plan to use this software in a commercial product, you are required to
 * purchase a commercial license from Oryx Embedded SARL.
 *
 * After the 90-day evaluation period, you agree to either purchase a commercial
 * license or delete all copies of this software. If you wish to extend the
 * evaluation period, you must contact sales@oryx-embedded.com.
 *
 * This evaluation software is provided "as is" without warranty of any kind.
 * Technical support is available as an option during the evaluation period.

 *
 * @author Oryx Embedded SARL (www.oryx-embedded.com)
 * @version 2.6.0
 **/

#ifndef _BOOT_SECURE_H
#define _BOOT_SECURE_H

#include "modules/image/image.h"
#include "second_stage/boot.h"

// Include crypto header files needed for image verification
#include "ecc/ec.h"
#include "ecc/ecdsa.h"
#include "pkix/pem_key_import.h"
#include "pkc/rsa.h"
#include "pkix/pem_key_import.h"

#define ECDSA_SIGNATURE_SIZE 64 //For curve SECP256K1_CURVE
#define RSA_SIGNATURE_SIZE   256 //For RSA-2048

cboot_error_t bootCheckRuntimeImageSignature(BootContext *context, Slot *slot);

#endif
