/**
 * @file mcu.h
 * @brief CycloneBOOT MCU layer
 *
 * @section License
 *
 * Copyright (C) 2021-2026 Oryx Embedded SARL. All rights reserved.
 *
 * This file is part of CycloneBOOT Eval
 * 
 * This software is provided in source form for a short-term evaluation only. The
 * evaluation license expires 90 days after the date you first download the software.
 *
 * If you plan to use this software in a commercial product, you are required to
 * purchase a commercial license from Oryx Embedded SARL.
 *
 * After the 90-day evaluation period, you agree to either purchase a commercial
 * license or delete all copies of this software. If you wish to extend the
 * evaluation period, you must contact sales@oryx-embedded.com.
 *
 * This evaluation software is provided "as is" without warranty of any kind.
 * Technical support is available as an option during the evaluation period.

 *
 * @author Oryx Embedded SARL (www.oryx-embedded.com)
 * @version 2.6.0
 **/

#ifndef _MCU_H
#define _MCU_H

// Dependencies
#include "boot_config.h"
#include "os_port.h"

#include <stdint.h>

#ifndef BOOT_CUSTOM_DEINIT_SUPPORT
#define BOOT_CUSTOM_DEINIT_SUPPORT DISABLED
#elif ((BOOT_CUSTOM_DEINIT_SUPPORT != ENABLED) && (BOOT_CUSTOM_DEINIT_SUPPORT != DISABLED))
#error BOOT_CUSTOM_DEINIT_SUPPORT parameter is not valid!
#endif

// CycloneBOOT MCU Driver Major version
#define MCU_DRIVER_VERSION_MAJOR 0x01
// CycloneBOOT MCU Driver Minor version
#define MCU_DRIVER_VERSION_MINOR 0x00
// CycloneBOOT MCU Driver Revision version
#define MCU_DRIVER_VERSION_PATCH 0x00
// CycloneBOOT MCU Driver version
#define MCU_DRIVER_VERSION                                                                         \
        (uint32_t)(((MCU_DRIVER_VERSION_MAJOR & 0xFF) << 16) |                                         \
        ((MCU_DRIVER_VERSION_MINOR & 0xFF) << 8) | (MCU_DRIVER_VERSION_PATCH & 0xFF))

// C++ guard
#ifdef __cplusplus
extern "C"
{
#endif

// CycloneBOOT mcu layer related functions
extern uint32_t mcuGetVtorOffset(void);
extern void mcuSystemReset(void);

#if defined(__CC_ARM)
void mcuJumpToApplication(uint32_t address) __attribute__((section(".code_in_ram")));
#elif (defined(__GNUC__) && defined(__MINGW32__)) || (defined(__GNUC__) && defined(__MINGW64__))
void mcuJumpToApplication(uint32_t address) __attribute__((section(".code_in_ram")));
#elif defined(__GNUC__)
void mcuJumpToApplication(uint32_t address) __attribute__((section(".code_in_ram")));
#elif defined(_MSC_VER)
extern void mcuJumpToApplication(uint32_t address);
#endif

// C++ guard
#ifdef __cplusplus
}
#endif
#endif //!_MCU_H
