/**
 * @file at25sf128a_flash_driver.h
 * @brief CycloneBOOT AT25SF128A Flash Driver
 *
 * @section License
 *
 * Copyright (C) 2021-2026 Oryx Embedded SARL. All rights reserved.
 *
 * This file is part of CycloneBOOT Eval
 * 
 * This software is provided in source form for a short-term evaluation only. The
 * evaluation license expires 90 days after the date you first download the software.
 *
 * If you plan to use this software in a commercial product, you are required to
 * purchase a commercial license from Oryx Embedded SARL.
 *
 * After the 90-day evaluation period, you agree to either purchase a commercial
 * license or delete all copies of this software. If you wish to extend the
 * evaluation period, you must contact sales@oryx-embedded.com.
 *
 * This evaluation software is provided "as is" without warranty of any kind.
 * Technical support is available as an option during the evaluation period.

 *
 * @author Oryx Embedded SARL (www.oryx-embedded.com)
 * @version 2.6.0
 **/

#ifndef AT25SF128A_FLASH_DRIVER_H
#define AT25SF128A_FLASH_DRIVER_H

// Dependencies
#include "core/flash.h"
#include "error.h"
#include "spi_flash_driver.h"

#include <stdint.h>
#include <stdlib.h>

// MEMORY name
#define AT25SF128A_NAME "AT25SF128A SPI Flash"
// MEMORY start addr
#define AT25SF128A_ADDR 0x00000000
// MEMORY size
#define AT25SF128A_SIZE AT25SF128A_TOTAL_SIZE
// MEMORY write size
#define AT25SF128A_WRITE_SIZE 0x04 // 4-bytes word
// MEMORY read size
#define AT25SF128A_READ_SIZE 0x04 // 4-bytes word

// AT25SF128A Memory Flash driver
extern const FlashDriver at25sf128aFlashDriver;

#endif //! AT25SF128A_FLASH_DRIVER_H
