/**
 * @file mcxn947_crypto_pkc.h
 * @brief NXP MCX N947 public-key hardware accelerator
 *
 * @section License
 *
 * Copyright (C) 2021-2026 Oryx Embedded SARL. All rights reserved.
 *
 * This file is part of CycloneCRYPTO Eval
 * 
 * This software is provided in source form for a short-term evaluation only. The
 * evaluation license expires 90 days after the date you first download the software.
 *
 * If you plan to use this software in a commercial product, you are required to
 * purchase a commercial license from Oryx Embedded SARL.
 *
 * After the 90-day evaluation period, you agree to either purchase a commercial
 * license or delete all copies of this software. If you wish to extend the
 * evaluation period, you must contact sales@oryx-embedded.com.
 *
 * This evaluation software is provided "as is" without warranty of any kind.
 * Technical support is available as an option during the evaluation period.

 *
 * @author Oryx Embedded SARL (www.oryx-embedded.com)
 * @version 2.6.0
 **/

#ifndef _MCXN947_CRYPTO_PKC_H
#define _MCXN947_CRYPTO_PKC_H

//Dependencies
#include "core/crypto.h"
#include <mcuxClEcc.h>

//Public-key hardware accelerator
#ifndef MCXN947_CRYPTO_PKC_SUPPORT
   #define MCXN947_CRYPTO_PKC_SUPPORT DISABLED
#elif (MCXN947_CRYPTO_PKC_SUPPORT != ENABLED && MCXN947_CRYPTO_PKC_SUPPORT != DISABLED)
   #error MCXN947_CRYPTO_PKC_SUPPORT parameter is not valid
#endif

//C++ guard
#ifdef __cplusplus
extern "C" {
#endif


/**
 * @brief RSA primitive arguments
 **/

typedef struct
{
   uint8_t n[512];
   uint8_t e[512];
   uint8_t d[512];
   uint8_t p[512];
   uint8_t q[512];
   uint8_t dp[512];
   uint8_t dq[512];
   uint8_t qinv[512];
   uint8_t m[512];
   uint8_t c[512];
} ElsRsaArgs;


/**
 * @brief ELS ECC primitive arguments
 **/

typedef struct
{
   uint8_t p[66];
   uint8_t a[66];
   uint8_t b[66];
   uint8_t g[132];
   uint8_t q[66];
   uint8_t d[66];
   uint8_t input[132];
   uint8_t output[132];
} ElsEccArgs;


/**
 * @brief ELS ECDSA primitive arguments
 **/

typedef struct
{
   uint8_t p[66];
   uint8_t a[66];
   uint8_t b[66];
   uint8_t g[132];
   uint8_t q[66];
   uint8_t privateKey[66];
   uint8_t publicKey[132];
   uint8_t signature[132];
   uint8_t r[66];
} ElsEcdsaArgs;


/**
 * @brief ELS MontDH primitive arguments
 **/

typedef struct
{
   uint32_t privKeyDesc[MCUXCLKEY_DESCRIPTOR_SIZE_IN_WORDS];
   uint32_t pubKeyDesc[MCUXCLKEY_DESCRIPTOR_SIZE_IN_WORDS];
   uint8_t sharedSecret[MCUXCLECC_MONTDH_CURVE448_SIZE_SHAREDSECRET];
} ElsMontDhArgs;


/**
 * @brief ELS EdDSA primitive arguments
 **/

typedef struct
{
   uint32_t privKeyDesc[MCUXCLKEY_DESCRIPTOR_SIZE_IN_WORDS];
   uint8_t privKeyData[MCUXCLECC_EDDSA_ED25519_SIZE_PRIVATEKEYDATA];
   uint32_t pubKeyDesc[MCUXCLKEY_DESCRIPTOR_SIZE_IN_WORDS];
   uint8_t pubKeyData[MCUXCLECC_EDDSA_ED25519_SIZE_PUBLICKEY];
   uint32_t keyPairDesc[MCUXCLECC_EDDSA_GENERATEKEYPAIR_DESCRIPTOR_SIZE_IN_WORDS];
   uint32_t protocolDesc[MCUXCLECC_EDDSA_ED25519_SIGNATURE_PROTOCOL_DESCRIPTOR_SIZE_IN_WORD(256)];
   uint8_t signature[MCUXCLECC_EDDSA_ED25519_SIZE_SIGNATURE];
} ElsEddsaArgs;


//C++ guard
#ifdef __cplusplus
}
#endif

#endif
