/**
 * @file mimxrt1180_crypto_pkc.h
 * @brief i.MX RT1180 public-key hardware accelerator
 *
 * @section License
 *
 * Copyright (C) 2021-2026 Oryx Embedded SARL. All rights reserved.
 *
 * This file is part of CycloneCRYPTO Eval
 * 
 * This software is provided in source form for a short-term evaluation only. The
 * evaluation license expires 90 days after the date you first download the software.
 *
 * If you plan to use this software in a commercial product, you are required to
 * purchase a commercial license from Oryx Embedded SARL.
 *
 * After the 90-day evaluation period, you agree to either purchase a commercial
 * license or delete all copies of this software. If you wish to extend the
 * evaluation period, you must contact sales@oryx-embedded.com.
 *
 * This evaluation software is provided "as is" without warranty of any kind.
 * Technical support is available as an option during the evaluation period.

 *
 * @author Oryx Embedded SARL (www.oryx-embedded.com)
 * @version 2.6.0
 **/

#ifndef _MIMXRT1180_CRYPTO_PKC_H
#define _MIMXRT1180_CRYPTO_PKC_H

//Dependencies
#include "core/crypto.h"

//Public-key hardware accelerator
#ifndef MIMXRT1180_CRYPTO_PKC_SUPPORT
   #define MIMXRT1180_CRYPTO_PKC_SUPPORT DISABLED
#elif (MIMXRT1180_CRYPTO_PKC_SUPPORT != ENABLED && MIMXRT1180_CRYPTO_PKC_SUPPORT != DISABLED)
   #error MIMXRT1180_CRYPTO_PKC_SUPPORT parameter is not valid
#endif

//C++ guard
#ifdef __cplusplus
extern "C" {
#endif


/**
 * @brief ELE RSA primitive arguments
 **/

typedef struct
{
   uint8_t n[512];
   uint8_t d[512];
   uint8_t e[512];
   uint8_t m[512];
   uint8_t c[512];
   uint8_t digest[32];
   uint8_t signature[512];
   char_t label[512];
} EleRsaArgs;


//C++ guard
#ifdef __cplusplus
}
#endif

#endif
