/**
 * @file s32k1_crypto.h
 * @brief S32K1 hardware cryptographic accelerator (CSEc)
 *
 * @section License
 *
 * Copyright (C) 2021-2026 Oryx Embedded SARL. All rights reserved.
 *
 * This file is part of CycloneCRYPTO Eval
 * 
 * This software is provided in source form for a short-term evaluation only. The
 * evaluation license expires 90 days after the date you first download the software.
 *
 * If you plan to use this software in a commercial product, you are required to
 * purchase a commercial license from Oryx Embedded SARL.
 *
 * After the 90-day evaluation period, you agree to either purchase a commercial
 * license or delete all copies of this software. If you wish to extend the
 * evaluation period, you must contact sales@oryx-embedded.com.
 *
 * This evaluation software is provided "as is" without warranty of any kind.
 * Technical support is available as an option during the evaluation period.

 *
 * @author Oryx Embedded SARL (www.oryx-embedded.com)
 * @version 2.6.0
 **/

#ifndef _S32K1_CRYPTO_H
#define _S32K1_CRYPTO_H

//Dependencies
#include "core/crypto.h"

//Commands
#define CSEC_CMD_ENC_ECB             0x01000000
#define CSEC_CMD_ENC_CBC             0x02000000
#define CSEC_CMD_DEC_ECB             0x03000000
#define CSEC_CMD_DEC_CBC             0x04000000
#define CSEC_CMD_GENERATE_MAC        0x05000000
#define CSEC_CMD_VERIFY_MAC          0x06000000
#define CSEC_CMD_LOAD_KEY            0x07000000
#define CSEC_CMD_LOAD_PLAIN_KEY      0x08000000
#define CSEC_CMD_EXPORT_RAM_KEY      0x09000000
#define CSEC_CMD_INIT_RNG            0x0A000000
#define CSEC_CMD_EXTEND_SEED         0x0B000000
#define CSEC_CMD_RND                 0x0C000000
#define CSEC_CMD_BOOT_FAILURE        0x0E000000
#define CSEC_CMD_BOOT_OK             0x0F000000
#define CSEC_CMD_GET_ID              0x10000000
#define CSEC_CMD_BOOT_DEFINE         0x11000000
#define CSEC_CMD_DBG_CHAL            0x12000000
#define CSEC_CMD_DBG_AUTH            0x13000000
#define CSEC_CMD_MP_COMPRESS         0x16000000

//Function format
#define CSEC_FORMAT_COPY             0x00000000
#define CSEC_FORMAT_POINTER          0x00010000

//Call sequence
#define CSEC_CALL_SEQ_FIRST          0x00000000
#define CSEC_CALL_SEQ_SUBSEQUENT     0x00000100

//Key identifiers
#define CSEC_SECRET_KEY              0x00000000
#define CSEC_MASTER_ECU_KEY          0x00000001
#define CSEC_BOOT_MAC_KEY            0x00000002
#define CSEC_BOOT_MAC                0x00000003
#define CSEC_KEY_1                   0x00000004
#define CSEC_KEY_2                   0x00000005
#define CSEC_KEY_3                   0x00000006
#define CSEC_KEY_4                   0x00000007
#define CSEC_KEY_5                   0x00000008
#define CSEC_KEY_6                   0x00000009
#define CSEC_KEY_7                   0x0000000A
#define CSEC_KEY_8                   0x0000000B
#define CSEC_KEY_9                   0x0000000C
#define CSEC_KEY_10                  0x0000000D
#define CSEC_RAM_KEY                 0x0000000F
#define CSEC_KEY_11                  0x00000014
#define CSEC_KEY_12                  0x00000015
#define CSEC_KEY_13                  0x00000016
#define CSEC_KEY_14                  0x00000017
#define CSEC_KEY_15                  0x00000018
#define CSEC_KEY_16                  0x00000019
#define CSEC_KEY_17                  0x0000001A
#define CSEC_KEY_18                  0x0000001B
#define CSEC_KEY_19                  0x0000001C
#define CSEC_KEY_20                  0x0000001D
#define CSEC_KEY_21                  0x0000001E

//Error codes
#define CSEC_ERC_NO_ERROR            0x0001
#define CSEC_ERC_SEQUENCE_ERROR      0x0002
#define CSEC_ERC_KEY_NOT_AVAILABLE   0x0004
#define CSEC_ERC_KEY_INVALID         0x0008
#define CSEC_ERC_KEY_EMPTY           0x0010
#define CSEC_ERC_NO_SECURE_BOOT      0x0020
#define CSEC_ERC_KEY_WRITE_PROTECTED 0x0040
#define CSEC_ERC_KEY_UPDATE_ERROR    0x0080
#define CSEC_ERC_RNG_SEED            0x0100
#define CSEC_ERC_NO_DEBUGGING        0x0200
#define CSEC_ERC_MEMORY_FAILURE      0x0400
#define CSEC_ERC_GENERAL_ERROR       0x0800

//C++ guard
#ifdef __cplusplus
extern "C" {
#endif

//Global variables
extern OsMutex s32k1CryptoMutex;

//S32K1 hardware cryptographic accelerator related functions
error_t s32k1CryptoInit(void);

//C++ guard
#ifdef __cplusplus
}
#endif

#endif
