/**
 * @file ascon_cxof128.h
 * @brief Ascon-CXOF128 customizable extendable-output function
 *
 * @section License
 *
 * Copyright (C) 2021-2026 Oryx Embedded SARL. All rights reserved.
 *
 * This file is part of CycloneCRYPTO Eval
 * 
 * This software is provided in source form for a short-term evaluation only. The
 * evaluation license expires 90 days after the date you first download the software.
 *
 * If you plan to use this software in a commercial product, you are required to
 * purchase a commercial license from Oryx Embedded SARL.
 *
 * After the 90-day evaluation period, you agree to either purchase a commercial
 * license or delete all copies of this software. If you wish to extend the
 * evaluation period, you must contact sales@oryx-embedded.com.
 *
 * This evaluation software is provided "as is" without warranty of any kind.
 * Technical support is available as an option during the evaluation period.

 *
 * @author Oryx Embedded SARL (www.oryx-embedded.com)
 * @version 2.6.0
 **/

#ifndef _ASCON_CXOF128_H
#define _ASCON_CXOF128_H

//Dependencies
#include "core/crypto.h"
#include "lwc/ascon.h"

//C++ guard
#ifdef __cplusplus
extern "C" {
#endif


/**
 * @brief Ascon-CXOF128 algorithm context
 **/

typedef struct
{
   AsconState state;
   uint8_t buffer[8];
   size_t length;
} AsconCxof128Context;


//Ascon-CXOF128 related functions
error_t asconCxof128Compute(const void *input, size_t inputLen,
   const char_t *custom, size_t customLen, uint8_t *output, size_t outputLen);

error_t asconCxof128Init(AsconCxof128Context *context, const char_t *custom,
   size_t customLen);

void asconCxof128Absorb(AsconCxof128Context *context, const void *input,
   size_t length);

void asconCxof128Final(AsconCxof128Context *context);

void asconCxof128Squeeze(AsconCxof128Context *context, uint8_t *output,
   size_t length);

//C++ guard
#ifdef __cplusplus
}
#endif

#endif
