/**
 * @file ascon_hash256.h
 * @brief Ascon-Hash256 hash function
 *
 * @section License
 *
 * Copyright (C) 2021-2026 Oryx Embedded SARL. All rights reserved.
 *
 * This file is part of CycloneCRYPTO Eval
 * 
 * This software is provided in source form for a short-term evaluation only. The
 * evaluation license expires 90 days after the date you first download the software.
 *
 * If you plan to use this software in a commercial product, you are required to
 * purchase a commercial license from Oryx Embedded SARL.
 *
 * After the 90-day evaluation period, you agree to either purchase a commercial
 * license or delete all copies of this software. If you wish to extend the
 * evaluation period, you must contact sales@oryx-embedded.com.
 *
 * This evaluation software is provided "as is" without warranty of any kind.
 * Technical support is available as an option during the evaluation period.

 *
 * @author Oryx Embedded SARL (www.oryx-embedded.com)
 * @version 2.6.0
 **/

#ifndef _ASCON_HASH256_H
#define _ASCON_HASH256_H

//Dependencies
#include "core/crypto.h"
#include "lwc/ascon.h"

//Application specific context
#ifndef ASCON_HASH256_PRIVATE_CONTEXT
   #define ASCON_HASH256_PRIVATE_CONTEXT
#endif

//Ascon-Hash256 block size
#define ASCON_HASH256_BLOCK_SIZE 8
//Ascon-Hash256 digest size
#define ASCON_HASH256_DIGEST_SIZE 32
//Minimum length of the padding string
#define ASCON_HASH256_MIN_PAD_SIZE 0
//Common interface for hash algorithms
#define ASCON_HASH256_HASH_ALGO (&asconHash256HashAlgo)

//C++ guard
#ifdef __cplusplus
extern "C" {
#endif


/**
 * @brief Ascon-Hash256 algorithm context
 **/

typedef struct
{
   AsconState state;
   uint8_t buffer[8];
   size_t length;
} AsconHash256Context;


//Ascon-Hash256 related constants
extern const uint8_t ASCON_HASH256_OID[1];
extern const HashAlgo asconHash256HashAlgo;

//Ascon-Hash256 related functions
error_t asconHash256Compute(const void *data, size_t length, uint8_t *digest);
void asconHash256Init(AsconHash256Context *context);
void asconHash256Update(AsconHash256Context *context, const void *data, size_t length);
void asconHash256Final(AsconHash256Context *context, uint8_t *digest);

//C++ guard
#ifdef __cplusplus
}
#endif

#endif
