/**
 * @file ascon_xof128.h
 * @brief Ascon-XOF128 extendable-output function
 *
 * @section License
 *
 * Copyright (C) 2021-2026 Oryx Embedded SARL. All rights reserved.
 *
 * This file is part of CycloneCRYPTO Eval
 * 
 * This software is provided in source form for a short-term evaluation only. The
 * evaluation license expires 90 days after the date you first download the software.
 *
 * If you plan to use this software in a commercial product, you are required to
 * purchase a commercial license from Oryx Embedded SARL.
 *
 * After the 90-day evaluation period, you agree to either purchase a commercial
 * license or delete all copies of this software. If you wish to extend the
 * evaluation period, you must contact sales@oryx-embedded.com.
 *
 * This evaluation software is provided "as is" without warranty of any kind.
 * Technical support is available as an option during the evaluation period.

 *
 * @author Oryx Embedded SARL (www.oryx-embedded.com)
 * @version 2.6.0
 **/

#ifndef _ASCON_XOF128_H
#define _ASCON_XOF128_H

//Dependencies
#include "core/crypto.h"
#include "lwc/ascon.h"

//Common interface for XOF algorithms
#define ASCON_XOF128_XOF_ALGO (&asconXof128XofAlgo)

//C++ guard
#ifdef __cplusplus
extern "C" {
#endif


/**
 * @brief Ascon-XOF128 algorithm context
 **/

typedef struct
{
   AsconState state;
   uint8_t buffer[8];
   size_t length;
} AsconXof128Context;


//Ascon-XOF128 related constants
extern const uint8_t ASCON_XOF128_OID[1];
extern const XofAlgo asconXof128XofAlgo;

//Ascon-XOF128 related functions
error_t asconXof128Compute(const void *input, size_t inputLen, uint8_t *output,
   size_t outputLen);

void asconXof128Init(AsconXof128Context *context);

void asconXof128Absorb(AsconXof128Context *context, const void *input,
   size_t length);

void asconXof128Final(AsconXof128Context *context);

void asconXof128Squeeze(AsconXof128Context *context, uint8_t *output,
   size_t length);

//C++ guard
#ifdef __cplusplus
}
#endif

#endif
