/**
 * @file pkcs7_sign_generate.h
 * @brief PKCS #7 signature generation
 *
 * @section License
 *
 * Copyright (C) 2021-2026 Oryx Embedded SARL. All rights reserved.
 *
 * This file is part of CycloneCRYPTO Eval
 * 
 * This software is provided in source form for a short-term evaluation only. The
 * evaluation license expires 90 days after the date you first download the software.
 *
 * If you plan to use this software in a commercial product, you are required to
 * purchase a commercial license from Oryx Embedded SARL.
 *
 * After the 90-day evaluation period, you agree to either purchase a commercial
 * license or delete all copies of this software. If you wish to extend the
 * evaluation period, you must contact sales@oryx-embedded.com.
 *
 * This evaluation software is provided "as is" without warranty of any kind.
 * Technical support is available as an option during the evaluation period.

 *
 * @author Oryx Embedded SARL (www.oryx-embedded.com)
 * @version 2.6.0
 **/

#ifndef _PKCS7_SIGN_GENERATE_H
#define _PKCS7_SIGN_GENERATE_H

//Dependencies
#include "core/crypto.h"
#include "pkcs7/pkcs7_common.h"

//C++ guard
#ifdef __cplusplus
extern "C" {
#endif

//PKCS #7 related functions
error_t pkcs7GenerateSignedData(const PrngAlgo *prngAlgo, void *prngContext,
   const uint8_t *content, size_t contentLen, const X509CertInfo *signerCertInfo,
   const Pkcs7AuthenticatedAttributes *authenticatedAttributes,
   const Pkcs7UnauthenticatedAttributes *unauthenticatedAttributes,
   const X509SignAlgoId *signatureAlgo, const void *signerPrivateKey,
   uint8_t *output, size_t *written);

error_t pkcs7GenerateSignature(const PrngAlgo *prngAlgo, void *prngContext,
   const uint8_t *digest, const Pkcs7SignerInfo *signerInfo,
   const void *privateKey, uint8_t *output, size_t *written);

error_t pkcs7GenerateRsaSignature(const uint8_t *digest,
   const Pkcs7SignerInfo *signerInfo, const RsaPrivateKey *privateKey,
   uint8_t *output, size_t *written);

//C++ guard
#ifdef __cplusplus
}
#endif

#endif
