/**
 * @file pem_cert_key_import.h
 * @brief PEM certificate public key import functions
 *
 * @section License
 *
 * Copyright (C) 2021-2026 Oryx Embedded SARL. All rights reserved.
 *
 * This file is part of CycloneCRYPTO Eval
 * 
 * This software is provided in source form for a short-term evaluation only. The
 * evaluation license expires 90 days after the date you first download the software.
 *
 * If you plan to use this software in a commercial product, you are required to
 * purchase a commercial license from Oryx Embedded SARL.
 *
 * After the 90-day evaluation period, you agree to either purchase a commercial
 * license or delete all copies of this software. If you wish to extend the
 * evaluation period, you must contact sales@oryx-embedded.com.
 *
 * This evaluation software is provided "as is" without warranty of any kind.
 * Technical support is available as an option during the evaluation period.

 *
 * @author Oryx Embedded SARL (www.oryx-embedded.com)
 * @version 2.6.0
 **/

#ifndef _PEM_CERT_KEY_IMPORT_H
#define _PEM_CERT_KEY_IMPORT_H

//Dependencies
#include "core/crypto.h"
#include "pkix/pem_common.h"
#include "pkix/x509_common.h"
#include "pkc/rsa.h"
#include "pkc/dsa.h"
#include "ecc/ec.h"
#include "ecc/eddsa.h"

//C++ guard
#ifdef __cplusplus
extern "C" {
#endif

//PEM related functions
error_t pemImportRsaCertPublicKey(RsaPublicKey *publicKey, const char_t *input,
   size_t length);

error_t pemImportDsaCertPublicKey(DsaPublicKey *publicKey, const char_t *input,
   size_t length);

error_t pemImportEcCertPublicKey(EcPublicKey *publicKey, const char_t *input,
   size_t length);

error_t pemImportEddsaCertPublicKey(EddsaPublicKey *publicKey,
   const char_t *input, size_t length);

X509KeyType pemGetCertPublicKeyType(const char_t *input, size_t length);

//C++ guard
#ifdef __cplusplus
}
#endif

#endif
