/**
 * @file pem_export.h
 * @brief PEM file export functions
 *
 * @section License
 *
 * Copyright (C) 2021-2026 Oryx Embedded SARL. All rights reserved.
 *
 * This file is part of CycloneCRYPTO Eval
 * 
 * This software is provided in source form for a short-term evaluation only. The
 * evaluation license expires 90 days after the date you first download the software.
 *
 * If you plan to use this software in a commercial product, you are required to
 * purchase a commercial license from Oryx Embedded SARL.
 *
 * After the 90-day evaluation period, you agree to either purchase a commercial
 * license or delete all copies of this software. If you wish to extend the
 * evaluation period, you must contact sales@oryx-embedded.com.
 *
 * This evaluation software is provided "as is" without warranty of any kind.
 * Technical support is available as an option during the evaluation period.

 *
 * @author Oryx Embedded SARL (www.oryx-embedded.com)
 * @version 2.6.0
 **/

#ifndef _PEM_EXPORT_H
#define _PEM_EXPORT_H

//Dependencies
#include "core/crypto.h"
#include "pkix/pem_common.h"
#include "ecc/ec.h"

//C++ guard
#ifdef __cplusplus
extern "C" {
#endif

//PEM related functions
error_t pemExportCertificate(const uint8_t *cert, size_t certLen,
   char_t *output, size_t *written);

error_t pemExportCrl(const uint8_t *crl, size_t crlLen,
   char_t *output, size_t *written);

error_t pemExportCsr(const uint8_t *csr, size_t csrLen,
   char_t *output, size_t *written);

error_t pemExportEcParameters(const EcCurve *curve, char_t *output,
   size_t *written);

//C++ guard
#ifdef __cplusplus
}
#endif

#endif
