/**
 * @file prng_algorithms.h
 * @brief Collection of PRNG algorithms
 *
 * @section License
 *
 * Copyright (C) 2021-2026 Oryx Embedded SARL. All rights reserved.
 *
 * This file is part of CycloneCRYPTO Eval
 * 
 * This software is provided in source form for a short-term evaluation only. The
 * evaluation license expires 90 days after the date you first download the software.
 *
 * If you plan to use this software in a commercial product, you are required to
 * purchase a commercial license from Oryx Embedded SARL.
 *
 * After the 90-day evaluation period, you agree to either purchase a commercial
 * license or delete all copies of this software. If you wish to extend the
 * evaluation period, you must contact sales@oryx-embedded.com.
 *
 * This evaluation software is provided "as is" without warranty of any kind.
 * Technical support is available as an option during the evaluation period.

 *
 * @author Oryx Embedded SARL (www.oryx-embedded.com)
 * @version 2.6.0
 **/

#ifndef _PRNG_ALGORITHMS_H
#define _PRNG_ALGORITHMS_H

//Dependencies
#include "core/crypto.h"

//Hash_DRBG PRNG support?
#if (HASH_DRBG_SUPPORT == ENABLED)
   #include "rng/hash_drbg.h"
#endif

//HMAC_DRBG PRNG support?
#if (HMAC_DRBG_SUPPORT == ENABLED)
   #include "rng/hmac_drbg.h"
#endif

//CTR_DRBG PRNG support?
#if (CTR_DRBG_SUPPORT == ENABLED)
   #include "rng/ctr_drbg.h"
#endif

//XDRBG PRNG support?
#if (XDRBG_SUPPORT == ENABLED)
   #include "rng/xdrbg.h"
#endif

//Yarrow PRNG support?
#if (YARROW_SUPPORT == ENABLED)
   #include "rng/yarrow.h"
#endif

//C++ guard
#ifdef __cplusplus
extern "C" {
#endif


/**
 * @brief Generic PRNG algorithm context
 **/

typedef union
{
#if (HASH_DRBG_SUPPORT == ENABLED)
   HashDrbgContext hashDrbgContext;
#endif
#if (HMAC_DRBG_SUPPORT == ENABLED)
   HmacDrbgContext hmacDrbgContext;
#endif
#if (CTR_DRBG_SUPPORT == ENABLED)
   CtrDrbgContext ctrDrbgContext;
#endif
#if (XDRBG_SUPPORT == ENABLED)
   XdrbgContext xdrbgContext;
#endif
#if (YARROW_SUPPORT == ENABLED)
   YarrowContext yarrowContext;
#endif
} PrngContext;


//C++ guard
#ifdef __cplusplus
}
#endif

#endif
