/**
 * @file xof_algorithms.h
 * @brief Collection of XOF algorithms
 *
 * @section License
 *
 * Copyright (C) 2021-2026 Oryx Embedded SARL. All rights reserved.
 *
 * This file is part of CycloneCRYPTO Eval
 * 
 * This software is provided in source form for a short-term evaluation only. The
 * evaluation license expires 90 days after the date you first download the software.
 *
 * If you plan to use this software in a commercial product, you are required to
 * purchase a commercial license from Oryx Embedded SARL.
 *
 * After the 90-day evaluation period, you agree to either purchase a commercial
 * license or delete all copies of this software. If you wish to extend the
 * evaluation period, you must contact sales@oryx-embedded.com.
 *
 * This evaluation software is provided "as is" without warranty of any kind.
 * Technical support is available as an option during the evaluation period.

 *
 * @author Oryx Embedded SARL (www.oryx-embedded.com)
 * @version 2.6.0
 **/

#ifndef _XOF_ALGORITHMS_H
#define _XOF_ALGORITHMS_H

//Dependencies
#include "core/crypto.h"

//Keccak support?
#if (KECCAK_SUPPORT == ENABLED)
   #include "xof/keccak.h"
#endif

//SHAKE support?
#if (SHAKE_SUPPORT == ENABLED)
   #include "xof/shake.h"
#endif

//cSHAKE support?
#if (CSHAKE_SUPPORT == ENABLED)
   #include "xof/cshake.h"
#endif

//Ascon-XOF128 support?
#if (ASCON_XOF128_SUPPORT == ENABLED)
   #include "lwc/ascon_xof128.h"
#endif

//Ascon-CXOF128 support?
#if (ASCON_CXOF128_SUPPORT == ENABLED)
   #include "lwc/ascon_cxof128.h"
#endif

//C++ guard
#ifdef __cplusplus
extern "C" {
#endif


/**
 * @brief Generic XOF algorithm context
 **/

typedef union
{
#if (KECCAK_SUPPORT == ENABLED)
   KeccakContext keccakContext;
#endif
#if (SHAKE_SUPPORT == ENABLED)
   ShakeContext shakeContext;
#endif
#if (CSHAKE_SUPPORT == ENABLED)
   CshakeContext cshakeContext;
#endif
#if (ASCON_XOF128_SUPPORT == ENABLED)
   AsconXof128Context asconXof128Context;
#endif
#if (ASCON_CXOF128_SUPPORT == ENABLED)
   AsconCxof128Context asconCxof128Context;
#endif
} XofContext;


//C++ guard
#ifdef __cplusplus
}
#endif

#endif
