/**
 * @file scp_server_file.h
 * @brief File operations
 *
 * @section License
 *
 * Copyright (C) 2021-2026 Oryx Embedded SARL. All rights reserved.
 *
 * This file is part of CycloneSSH Eval
 * 
 * This software is provided in source form for a short-term evaluation only. The
 * evaluation license expires 90 days after the date you first download the software.
 *
 * If you plan to use this software in a commercial product, you are required to
 * purchase a commercial license from Oryx Embedded SARL.
 *
 * After the 90-day evaluation period, you agree to either purchase a commercial
 * license or delete all copies of this software. If you wish to extend the
 * evaluation period, you must contact sales@oryx-embedded.com.
 *
 * This evaluation software is provided "as is" without warranty of any kind.
 * Technical support is available as an option during the evaluation period.

 *
 * @author Oryx Embedded SARL (www.oryx-embedded.com)
 * @version 2.6.0
 **/

#ifndef _SCP_SERVER_FILE_H
#define _SCP_SERVER_FILE_H

//Dependencies
#include "scp/scp_server.h"

//C++ guard
#ifdef __cplusplus
extern "C" {
#endif

//SCP server related functions
error_t scpServerOpenFileForWriting(ScpServerSession *session,
   const char_t *filename, uint32_t mode, uint64_t size);

error_t scpServerOpenFileForReading(ScpServerSession *session);

error_t scpServerWriteData(ScpServerSession *session);
error_t scpServerReadData(ScpServerSession *session);

//C++ guard
#ifdef __cplusplus
}
#endif

#endif
