/**
 * @file scp_server_misc.h
 * @brief Helper functions for SCP server
 *
 * @section License
 *
 * Copyright (C) 2021-2026 Oryx Embedded SARL. All rights reserved.
 *
 * This file is part of CycloneSSH Eval
 * 
 * This software is provided in source form for a short-term evaluation only. The
 * evaluation license expires 90 days after the date you first download the software.
 *
 * If you plan to use this software in a commercial product, you are required to
 * purchase a commercial license from Oryx Embedded SARL.
 *
 * After the 90-day evaluation period, you agree to either purchase a commercial
 * license or delete all copies of this software. If you wish to extend the
 * evaluation period, you must contact sales@oryx-embedded.com.
 *
 * This evaluation software is provided "as is" without warranty of any kind.
 * Technical support is available as an option during the evaluation period.

 *
 * @author Oryx Embedded SARL (www.oryx-embedded.com)
 * @version 2.6.0
 **/

#ifndef _SCP_SERVER_MISC_H
#define _SCP_SERVER_MISC_H

//Dependencies
#include "scp/scp_server.h"
#include "ssh/ssh_request.h"

//C++ guard
#ifdef __cplusplus
extern "C" {
#endif

//SCP server related functions
void scpServerTick(ScpServerContext *context);

error_t scpServerChannelRequestCallback(SshChannel *channel,
   const SshString *type, const uint8_t *data, size_t length,
   void *param);

void scpServerParseCommandLine(ScpServerSession *session,
   const SshExecParams *requestParams);

ScpServerSession *scpServerFindSession(ScpServerContext *context,
   SshChannel *channel);

ScpServerSession *scpServerOpenSession(ScpServerContext *context,
   SshChannel *channel);

void scpServerCloseSession(ScpServerSession *session);

void scpServerRegisterSessionEvents(ScpServerSession *session,
   SshChannelEventDesc *eventDesc);

void scpServerProcessSessionEvents(ScpServerSession *session);

error_t scpServerSendDirective(ScpServerSession *session,
   const ScpDirective *directive);

error_t scpServerReceiveDirective(ScpServerSession *session,
   ScpDirective *directive);

void scpServerProcessDirective(ScpServerSession *session,
   const ScpDirective *directive);

uint_t scpServerGetFilePermissions(ScpServerSession *session,
   const char_t *path);

error_t scpServerGetPath(ScpServerSession *session, const SshString *path,
   char_t *fullPath, size_t maxLen);

const char_t *scpServerStripRootDir(ScpServerSession *session,
   const char_t *path);

//C++ guard
#ifdef __cplusplus
}
#endif

#endif
