/**
 * @file sftp_client_misc.h
 * @brief Helper functions for SFTP client
 *
 * @section License
 *
 * Copyright (C) 2021-2026 Oryx Embedded SARL. All rights reserved.
 *
 * This file is part of CycloneSSH Eval
 * 
 * This software is provided in source form for a short-term evaluation only. The
 * evaluation license expires 90 days after the date you first download the software.
 *
 * If you plan to use this software in a commercial product, you are required to
 * purchase a commercial license from Oryx Embedded SARL.
 *
 * After the 90-day evaluation period, you agree to either purchase a commercial
 * license or delete all copies of this software. If you wish to extend the
 * evaluation period, you must contact sales@oryx-embedded.com.
 *
 * This evaluation software is provided "as is" without warranty of any kind.
 * Technical support is available as an option during the evaluation period.

 *
 * @author Oryx Embedded SARL (www.oryx-embedded.com)
 * @version 2.6.0
 **/

#ifndef _SFTP_CLIENT_MISC_H
#define _SFTP_CLIENT_MISC_H

//Dependencies
#include "sftp/sftp_client.h"

//C++ guard
#ifdef __cplusplus
extern "C" {
#endif

//SFTP client related functions
void sftpClientChangeState(SftpClientContext *context,
   SftpClientState newState);

error_t sftpClientOpenConnection(SftpClientContext *context);
error_t sftpClientEstablishConnection(SftpClientContext *context);
void sftpClientCloseConnection(SftpClientContext *context);

error_t sftpClientSendCommand(SftpClientContext *context);
error_t sftpClientProcessEvents(SftpClientContext *context);

error_t sftpClientParsePacketLength(SftpClientContext *context,
   const uint8_t *packet);

error_t sftpClientParsePacket(SftpClientContext *context, const uint8_t *packet,
   size_t fragLen, size_t totalLen);

error_t sftpClientCheckTimeout(SftpClientContext *context);

error_t sftpFormatPath(SftpClientContext *context, const char_t *path,
   uint8_t *p, size_t *written);

void sftpGetAbsolutePath(SftpClientContext *context, const char_t *path,
   char_t *fullPath);

//C++ guard
#ifdef __cplusplus
}
#endif

#endif
