/**
 * @file sftp_client_packet.h
 * @brief SFTP packet parsing and formatting
 *
 * @section License
 *
 * Copyright (C) 2021-2026 Oryx Embedded SARL. All rights reserved.
 *
 * This file is part of CycloneSSH Eval
 * 
 * This software is provided in source form for a short-term evaluation only. The
 * evaluation license expires 90 days after the date you first download the software.
 *
 * If you plan to use this software in a commercial product, you are required to
 * purchase a commercial license from Oryx Embedded SARL.
 *
 * After the 90-day evaluation period, you agree to either purchase a commercial
 * license or delete all copies of this software. If you wish to extend the
 * evaluation period, you must contact sales@oryx-embedded.com.
 *
 * This evaluation software is provided "as is" without warranty of any kind.
 * Technical support is available as an option during the evaluation period.

 *
 * @author Oryx Embedded SARL (www.oryx-embedded.com)
 * @version 2.6.0
 **/

#ifndef _SFTP_CLIENT_PACKET_H
#define _SFTP_CLIENT_PACKET_H

//Dependencies
#include "sftp/sftp_client.h"

//C++ guard
#ifdef __cplusplus
extern "C" {
#endif

//SFTP client related functions
error_t sftpClientFormatFxpInit(SftpClientContext *context,
   uint32_t version);

error_t sftpClientFormatFxpOpen(SftpClientContext *context,
   const char_t *filename, uint32_t pflags);

error_t sftpClientFormatFxpClose(SftpClientContext *context,
   const uint8_t *handle, size_t handleLen);

error_t sftpClientFormatFxpRead(SftpClientContext *context,
   const uint8_t *handle, size_t handleLen, uint64_t offset, uint32_t dataLen);

error_t sftpClientFormatFxpWrite(SftpClientContext *context,
   const uint8_t *handle, size_t handleLen, uint64_t offset, uint32_t dataLen);

error_t sftpClientFormatFxpOpenDir(SftpClientContext *context,
   const char_t *path);

error_t sftpClientFormatFxpReadDir(SftpClientContext *context,
   const uint8_t *handle, size_t handleLen);

error_t sftpClientFormatFxpRemove(SftpClientContext *context,
   const char_t *filename);

error_t sftpClientFormatFxpMkDir(SftpClientContext *context,
   const char_t *path);

error_t sftpClientFormatFxpRmDir(SftpClientContext *context,
   const char_t *path);

error_t sftpClientFormatFxpRealPath(SftpClientContext *context,
   const char_t *path);

error_t sftpClientFormatFxpStat(SftpClientContext *context,
   const char_t *path);

error_t sftpClientFormatFxpRename(SftpClientContext *context,
   const char_t *oldPath, const char_t *newPath);

error_t sftpClientParseFxpVersion(SftpClientContext *context,
   const uint8_t *packet, size_t length);

error_t sftpClientParseFxpStatus(SftpClientContext *context,
   const uint8_t *packet, size_t length);

error_t sftpClientParseFxpHandle(SftpClientContext *context,
   const uint8_t *packet, size_t length);

error_t sftpClientParseFxpData(SftpClientContext *context,
   const uint8_t *packet, size_t fragLen, size_t totalLen);

error_t sftpClientParseFxpName(SftpClientContext *context,
   const uint8_t *packet, size_t fragLen, size_t totalLen);

error_t sftpClientParseFxpAttrs(SftpClientContext *context,
   const uint8_t *packet, size_t length);

//C++ guard
#ifdef __cplusplus
}
#endif

#endif
