/**
 * @file sftp_server_file.h
 * @brief File operations
 *
 * @section License
 *
 * Copyright (C) 2021-2026 Oryx Embedded SARL. All rights reserved.
 *
 * This file is part of CycloneSSH Eval
 * 
 * This software is provided in source form for a short-term evaluation only. The
 * evaluation license expires 90 days after the date you first download the software.
 *
 * If you plan to use this software in a commercial product, you are required to
 * purchase a commercial license from Oryx Embedded SARL.
 *
 * After the 90-day evaluation period, you agree to either purchase a commercial
 * license or delete all copies of this software. If you wish to extend the
 * evaluation period, you must contact sales@oryx-embedded.com.
 *
 * This evaluation software is provided "as is" without warranty of any kind.
 * Technical support is available as an option during the evaluation period.

 *
 * @author Oryx Embedded SARL (www.oryx-embedded.com)
 * @version 2.6.0
 **/

#ifndef _SFTP_SERVER_FILE_H
#define _SFTP_SERVER_FILE_H

//Dependencies
#include "sftp/sftp_server.h"

//C++ guard
#ifdef __cplusplus
extern "C" {
#endif

//SFTP server related functions
error_t sftpServerGetRealPath(SftpServerSession *session,
   const SshString *path, SftpName *name);

error_t sftpServerGetFileStat(SftpServerSession *session,
   const SshString *path, SftpFileAttrs *attributes);

error_t sftpServerGetFileStatEx(SftpServerSession *session,
   const SshBinaryString *handle, SftpFileAttrs *attributes);

error_t sftpServerSetFileStat(SftpServerSession *session,
   const SshString *path, const SftpFileAttrs *attributes);

error_t sftpServerSetFileStatEx(SftpServerSession *session,
   const SshBinaryString *handle, const SftpFileAttrs *attributes);

error_t sftpServerRemoveFile(SftpServerSession *session,
   const SshString *path);

error_t sftpServerRenameFile(SftpServerSession *session,
   const SshString *oldPath, const SshString *newPath);

error_t sftpServerOpenFile(SftpServerSession *session, const SshString *path,
   uint32_t pflags, const SftpFileAttrs *attributes, uint32_t *handle);

error_t sftpServerWriteFile(SftpServerSession *session,
   const SshBinaryString *handle, uint64_t offset, const uint8_t *data,
   uint32_t fragLen, uint32_t totalLen);

error_t sftpServerWriteData(SftpServerSession *session);

error_t sftpServerReadFile(SftpServerSession *session,
   const SshBinaryString *handle, uint64_t offset, uint32_t *length);

error_t sftpServerReadData(SftpServerSession *session);

error_t sftpServerCloseFile(SftpServerSession *session,
   const SshBinaryString *handle);

SftpFileObject *sftpServerFindFile(SftpServerSession *session,
   const SshBinaryString *handle);

//C++ guard
#ifdef __cplusplus
}
#endif

#endif
