/**
 * @file sftp_server_misc.h
 * @brief Helper functions for SFTP server
 *
 * @section License
 *
 * Copyright (C) 2021-2026 Oryx Embedded SARL. All rights reserved.
 *
 * This file is part of CycloneSSH Eval
 * 
 * This software is provided in source form for a short-term evaluation only. The
 * evaluation license expires 90 days after the date you first download the software.
 *
 * If you plan to use this software in a commercial product, you are required to
 * purchase a commercial license from Oryx Embedded SARL.
 *
 * After the 90-day evaluation period, you agree to either purchase a commercial
 * license or delete all copies of this software. If you wish to extend the
 * evaluation period, you must contact sales@oryx-embedded.com.
 *
 * This evaluation software is provided "as is" without warranty of any kind.
 * Technical support is available as an option during the evaluation period.

 *
 * @author Oryx Embedded SARL (www.oryx-embedded.com)
 * @version 2.6.0
 **/

#ifndef _SFTP_SERVER_MISC_H
#define _SFTP_SERVER_MISC_H

//Dependencies
#include "sftp/sftp_server.h"

//C++ guard
#ifdef __cplusplus
extern "C" {
#endif

//SFTP server related functions
void sftpServerTick(SftpServerContext *context);

error_t sftpServerChannelRequestCallback(SshChannel *channel,
   const SshString *type, const uint8_t *data, size_t length,
   void *param);

SftpServerSession *sftpServerFindSession(SftpServerContext *context,
   SshChannel *channel);

SftpServerSession *sftpServerOpenSession(SftpServerContext *context,
   SshChannel *channel);

void sftpServerCloseSession(SftpServerSession *session);

void sftpServerRegisterSessionEvents(SftpServerSession *session,
   SshChannelEventDesc *eventDesc);

void sftpServerProcessSessionEvents(SftpServerSession *session);

error_t sftpServerParsePacketLength(SftpServerSession *session,
   const uint8_t *packet);

error_t sftpServerParsePacket(SftpServerSession *session,
   const uint8_t *packet, size_t fragLen, size_t totalLen);

uint32_t sftpServerGenerateHandle(SftpServerSession *session);

uint_t sftpServerGetFilePermissions(SftpServerSession *session,
   const char_t *path);

error_t sftpServerGetPath(SftpServerSession *session, const SshString *path,
   char_t *fullPath, size_t maxLen);

const char_t *sftpServerStripRootDir(SftpServerContext *context,
   const char_t *path);

const char_t *sftpServerStripUserRootDir(SftpServerSession *session,
   const char_t *path);

//C++ guard
#ifdef __cplusplus
}
#endif

#endif
