/**
 * @file sftp_server_packet.h
 * @brief SFTP packet parsing and formatting
 *
 * @section License
 *
 * Copyright (C) 2021-2026 Oryx Embedded SARL. All rights reserved.
 *
 * This file is part of CycloneSSH Eval
 * 
 * This software is provided in source form for a short-term evaluation only. The
 * evaluation license expires 90 days after the date you first download the software.
 *
 * If you plan to use this software in a commercial product, you are required to
 * purchase a commercial license from Oryx Embedded SARL.
 *
 * After the 90-day evaluation period, you agree to either purchase a commercial
 * license or delete all copies of this software. If you wish to extend the
 * evaluation period, you must contact sales@oryx-embedded.com.
 *
 * This evaluation software is provided "as is" without warranty of any kind.
 * Technical support is available as an option during the evaluation period.

 *
 * @author Oryx Embedded SARL (www.oryx-embedded.com)
 * @version 2.6.0
 **/

#ifndef _SFTP_SERVER_PACKET_H
#define _SFTP_SERVER_PACKET_H

//Dependencies
#include "sftp/sftp_server.h"

//C++ guard
#ifdef __cplusplus
extern "C" {
#endif

//SFTP server related functions
error_t sftpServerParseFxpInit(SftpServerSession *session,
   const uint8_t *packet, size_t length);

error_t sftpServerParseFxpOpen(SftpServerSession *session,
   const uint8_t *packet, size_t length);

error_t sftpServerParseFxpClose(SftpServerSession *session,
   const uint8_t *packet, size_t length);

error_t sftpServerParseFxpRead(SftpServerSession *session,
   const uint8_t *packet, size_t length);

error_t sftpServerParseFxpWrite(SftpServerSession *session,
   const uint8_t *packet, size_t fragLen, size_t totalLen);

error_t sftpServerParseFxpOpenDir(SftpServerSession *session,
   const uint8_t *packet, size_t length);

error_t sftpServerParseFxpReadDir(SftpServerSession *session,
   const uint8_t *packet, size_t length);

error_t sftpServerParseFxpRemove(SftpServerSession *session,
   const uint8_t *packet, size_t length);

error_t sftpServerParseFxpMkDir(SftpServerSession *session,
   const uint8_t *packet, size_t length);

error_t sftpServerParseFxpRmDir(SftpServerSession *session,
   const uint8_t *packet, size_t length);

error_t sftpServerParseFxpRealPath(SftpServerSession *session,
   const uint8_t *packet, size_t length);

error_t sftpServerParseFxpStat(SftpServerSession *session,
   const uint8_t *packet, size_t length);

error_t sftpServerParseFxpFstat(SftpServerSession *session,
   const uint8_t *packet, size_t length);

error_t sftpServerParseFxpSetStat(SftpServerSession *session,
   const uint8_t *packet, size_t length);

error_t sftpServerParseFxpSetFstat(SftpServerSession *session,
   const uint8_t *packet, size_t length);

error_t sftpServerParseFxpRename(SftpServerSession *session,
   const uint8_t *packet, size_t length);

error_t sftpServerParseFxpExtended(SftpServerSession *session,
   const uint8_t *packet, size_t length);

error_t sftpFormatFxpVersion(SftpServerSession *session, uint32_t version);

error_t sftpFormatFxpStatus(SftpServerSession *session, uint32_t id,
   uint32_t statusCode, const char_t *message);

error_t sftpFormatFxpHandle(SftpServerSession *session, uint32_t id,
   uint32_t handle);

error_t sftpFormatFxpData(SftpServerSession *session, uint32_t id,
   size_t dataLen);

error_t sftpFormatFxpName(SftpServerSession *session, uint32_t id,
   const SftpName *name);

error_t sftpFormatFxpAttrs(SftpServerSession *session, uint32_t id,
   const SftpFileAttrs *attributes);

//C++ guard
#ifdef __cplusplus
}
#endif

#endif
