/**
 * @file shell_client_misc.h
 * @brief Helper functions for SSH secure shell client
 *
 * @section License
 *
 * Copyright (C) 2021-2026 Oryx Embedded SARL. All rights reserved.
 *
 * This file is part of CycloneSSH Eval
 * 
 * This software is provided in source form for a short-term evaluation only. The
 * evaluation license expires 90 days after the date you first download the software.
 *
 * If you plan to use this software in a commercial product, you are required to
 * purchase a commercial license from Oryx Embedded SARL.
 *
 * After the 90-day evaluation period, you agree to either purchase a commercial
 * license or delete all copies of this software. If you wish to extend the
 * evaluation period, you must contact sales@oryx-embedded.com.
 *
 * This evaluation software is provided "as is" without warranty of any kind.
 * Technical support is available as an option during the evaluation period.

 *
 * @author Oryx Embedded SARL (www.oryx-embedded.com)
 * @version 2.6.0
 **/

#ifndef _SHELL_CLIENT_MISC_H
#define _SHELL_CLIENT_MISC_H

//Dependencies
#include "shell/shell_client.h"

//C++ guard
#ifdef __cplusplus
extern "C" {
#endif

//Shell client related functions
void shellClientChangeState(ShellClientContext *context,
   ShellClientState newState);

error_t shellClientChannelRequestCallback(SshChannel *channel,
   const SshString *type, const uint8_t *data, size_t length,
   void *param);

error_t shellClientOpenConnection(ShellClientContext *context);
error_t shellClientEstablishConnection(ShellClientContext *context);
void shellClientCloseConnection(ShellClientContext *context);

error_t shellClientProcessEvents(ShellClientContext *context);
error_t shellClientCheckTimeout(ShellClientContext *context);

//C++ guard
#ifdef __cplusplus
}
#endif

#endif
