/**
 * @file shell_server_misc.h
 * @brief Helper functions for SSH secure shell server
 *
 * @section License
 *
 * Copyright (C) 2021-2026 Oryx Embedded SARL. All rights reserved.
 *
 * This file is part of CycloneSSH Eval
 * 
 * This software is provided in source form for a short-term evaluation only. The
 * evaluation license expires 90 days after the date you first download the software.
 *
 * If you plan to use this software in a commercial product, you are required to
 * purchase a commercial license from Oryx Embedded SARL.
 *
 * After the 90-day evaluation period, you agree to either purchase a commercial
 * license or delete all copies of this software. If you wish to extend the
 * evaluation period, you must contact sales@oryx-embedded.com.
 *
 * This evaluation software is provided "as is" without warranty of any kind.
 * Technical support is available as an option during the evaluation period.

 *
 * @author Oryx Embedded SARL (www.oryx-embedded.com)
 * @version 2.6.0
 **/

#ifndef _SHELL_SERVER_MISC_H
#define _SHELL_SERVER_MISC_H

//Dependencies
#include "shell/shell_server.h"
#include "ssh/ssh_request.h"

//C++ guard
#ifdef __cplusplus
extern "C" {
#endif

//Shell server related functions
void shellServerTick(ShellServerContext *context);

error_t shellServerChannelRequestCallback(SshChannel *channel,
   const SshString *type, const uint8_t *data, size_t length,
   void *param);

ShellServerSession *shellServerFindSession(ShellServerContext *context,
   SshChannel *channel);

ShellServerSession *shellServerOpenSession(ShellServerContext *context,
   SshChannel *channel);

void shellServerCloseSession(ShellServerSession *session);

error_t shellServerParseTermModes(ShellServerSession *session,
   const uint8_t *termModes, size_t length);

error_t shellServerProcessCommandLine(ShellServerSession *session,
   char_t *commandLine);

void shellServerAddCommandLine(ShellServerSession *session,
   const char_t *commandLine);

error_t shellServerGetPrevCommandLine(ShellServerSession *session,
   const char_t **commandLine, size_t *length);

error_t shellServerGetNextCommandLine(ShellServerSession *session,
   const char_t **commandLine, size_t *length);

error_t shellServerGetFirstCommandLine(ShellServerSession *session,
   const char_t **commandLine, size_t *length);

error_t shellServerGetLastCommandLine(ShellServerSession *session,
   const char_t **commandLine, size_t *length);

//C++ guard
#ifdef __cplusplus
}
#endif

#endif
