/**
 * @file ssh_cert_verify.h
 * @brief SSH certificate verification
 *
 * @section License
 *
 * Copyright (C) 2021-2026 Oryx Embedded SARL. All rights reserved.
 *
 * This file is part of CycloneSSH Eval
 * 
 * This software is provided in source form for a short-term evaluation only. The
 * evaluation license expires 90 days after the date you first download the software.
 *
 * If you plan to use this software in a commercial product, you are required to
 * purchase a commercial license from Oryx Embedded SARL.
 *
 * After the 90-day evaluation period, you agree to either purchase a commercial
 * license or delete all copies of this software. If you wish to extend the
 * evaluation period, you must contact sales@oryx-embedded.com.
 *
 * This evaluation software is provided "as is" without warranty of any kind.
 * Technical support is available as an option during the evaluation period.

 *
 * @author Oryx Embedded SARL (www.oryx-embedded.com)
 * @version 2.6.0
 **/

#ifndef _SSH_CERT_VERIFY_H
#define _SSH_CERT_VERIFY_H

//Dependencies
#include "ssh.h"
#include "ssh_cert_import.h"

//C++ guard
#ifdef __cplusplus
extern "C" {
#endif

//SSH certificate verification related functions
error_t sshVerifyClientCertificate(SshConnection *connection,
   const SshString *publicKeyAlgo, const SshBinaryString *hostKey,
   bool_t flag);

error_t sshVerifyServerCertificate(SshConnection *connection,
   const SshString *publicKeyAlgo, const SshBinaryString *hostKey);

error_t sshVerifyPrincipal(const SshCertificate *cert, const char_t *name);
error_t sshVerifyValidity(const SshCertificate *cert);

error_t sshVerifyCriticalOptions(SshConnection *connection,
   const SshCertificate *cert);

error_t sshVerifySrcAddrOption(SshConnection *connection,
   const SshBinaryString *optionData);

error_t sshVerifyCertSignature(SshConnection *connection,
   const SshCertificate *cert);

//C++ guard
#ifdef __cplusplus
}
#endif

#endif
