/**
 * @file ssh_extensions.h
 * @brief SSH extension negotiation
 *
 * @section License
 *
 * Copyright (C) 2021-2026 Oryx Embedded SARL. All rights reserved.
 *
 * This file is part of CycloneSSH Eval
 * 
 * This software is provided in source form for a short-term evaluation only. The
 * evaluation license expires 90 days after the date you first download the software.
 *
 * If you plan to use this software in a commercial product, you are required to
 * purchase a commercial license from Oryx Embedded SARL.
 *
 * After the 90-day evaluation period, you agree to either purchase a commercial
 * license or delete all copies of this software. If you wish to extend the
 * evaluation period, you must contact sales@oryx-embedded.com.
 *
 * This evaluation software is provided "as is" without warranty of any kind.
 * Technical support is available as an option during the evaluation period.

 *
 * @author Oryx Embedded SARL (www.oryx-embedded.com)
 * @version 2.6.0
 **/

#ifndef _SSH_EXTENSIONS_H
#define _SSH_EXTENSIONS_H

//Dependencies
#include "ssh/ssh.h"

//Minimum size of SSH_MSG_EXT_INFO message
#define SSH_MSG_EXT_INFO_MIN_SIZE 5

//C++ guard
#ifdef __cplusplus
extern "C" {
#endif

//SSH related functions
error_t sshSendExtInfo(SshConnection *connection);

error_t sshFormatExtInfo(SshConnection *connection, uint8_t *message,
   size_t *length);

error_t sshFormatServerSigAlgsExt(SshConnection *connection, uint8_t *p,
   size_t *written);

error_t sshFormatGlobalRequestsOkExt(SshConnection *connection, uint8_t *p,
   size_t *written);

error_t sshParseExtInfo(SshConnection *connection, const uint8_t *message,
   size_t length);

error_t sshParseServerSigAlgsExt(SshConnection *connection, const char_t *p,
   size_t length);

error_t sshParseGlobalRequestsOkExt(SshConnection *connection, const char_t *p,
   size_t length);

//C++ guard
#ifdef __cplusplus
}
#endif

#endif
