/**
 * @file ssh_kex.h
 * @brief SSH key exchange
 *
 * @section License
 *
 * Copyright (C) 2021-2026 Oryx Embedded SARL. All rights reserved.
 *
 * This file is part of CycloneSSH Eval
 * 
 * This software is provided in source form for a short-term evaluation only. The
 * evaluation license expires 90 days after the date you first download the software.
 *
 * If you plan to use this software in a commercial product, you are required to
 * purchase a commercial license from Oryx Embedded SARL.
 *
 * After the 90-day evaluation period, you agree to either purchase a commercial
 * license or delete all copies of this software. If you wish to extend the
 * evaluation period, you must contact sales@oryx-embedded.com.
 *
 * This evaluation software is provided "as is" without warranty of any kind.
 * Technical support is available as an option during the evaluation period.

 *
 * @author Oryx Embedded SARL (www.oryx-embedded.com)
 * @version 2.6.0
 **/

#ifndef _SSH_KEX_H
#define _SSH_KEX_H

//Dependencies
#include "ssh/ssh.h"

//C++ guard
#ifdef __cplusplus
extern "C" {
#endif

//SSH related functions
error_t sshSendKexInit(SshConnection *connection);
error_t sshSendNewKeys(SshConnection *connection);

error_t sshFormatKexInit(SshConnection *connection, uint8_t *p,
   size_t *length);

error_t sshFormatNewKeys(SshConnection *connection, uint8_t *p,
   size_t *length);

error_t sshParseKexInit(SshConnection *connection, const uint8_t *message,
   size_t length);

error_t sshParseNewKeys(SshConnection *connection, const uint8_t *message,
   size_t length);

error_t sshParseKexMessage(SshConnection *connection, uint8_t type,
   const uint8_t *message, size_t length);

error_t sshDigestClientKexInit(SshConnection *connection);

//C++ guard
#ifdef __cplusplus
}
#endif

#endif
