/**
 * @file ssh_kex_dh_gex.h
 * @brief DH GEX (Diffie-Hellman Group Exchange) key exchange
 *
 * @section License
 *
 * Copyright (C) 2021-2026 Oryx Embedded SARL. All rights reserved.
 *
 * This file is part of CycloneSSH Eval
 * 
 * This software is provided in source form for a short-term evaluation only. The
 * evaluation license expires 90 days after the date you first download the software.
 *
 * If you plan to use this software in a commercial product, you are required to
 * purchase a commercial license from Oryx Embedded SARL.
 *
 * After the 90-day evaluation period, you agree to either purchase a commercial
 * license or delete all copies of this software. If you wish to extend the
 * evaluation period, you must contact sales@oryx-embedded.com.
 *
 * This evaluation software is provided "as is" without warranty of any kind.
 * Technical support is available as an option during the evaluation period.

 *
 * @author Oryx Embedded SARL (www.oryx-embedded.com)
 * @version 2.6.0
 **/

#ifndef _SSH_KEX_DH_GEX_H
#define _SSH_KEX_DH_GEX_H

//Dependencies
#include "ssh/ssh.h"

//C++ guard
#ifdef __cplusplus
extern "C" {
#endif

//SSH related functions
error_t sshSendKexDhGexRequest(SshConnection *connection);
error_t sshSendKexDhGexGroup(SshConnection *connection);
error_t sshSendKexDhGexInit(SshConnection *connection);
error_t sshSendKexDhGexReply(SshConnection *connection);

error_t sshFormatKexDhGexRequest(SshConnection *connection, uint8_t *p,
   size_t *length);

error_t sshFormatKexDhGexGroup(SshConnection *connection, uint8_t *p,
   size_t *length);

error_t sshFormatKexDhGexInit(SshConnection *connection, uint8_t *p,
   size_t *length);

error_t sshFormatKexDhGexReply(SshConnection *connection, uint8_t *p,
   size_t *length);

error_t sshParseKexDhGexRequest(SshConnection *connection,
   const uint8_t *message, size_t length);

error_t sshParseKexDhGexRequestOld(SshConnection *connection,
   const uint8_t *message, size_t length);

error_t sshParseKexDhGexGroup(SshConnection *connection, const uint8_t *message,
   size_t length);

error_t sshParseKexDhGexInit(SshConnection *connection, const uint8_t *message,
   size_t length);

error_t sshParseKexDhGexReply(SshConnection *connection, const uint8_t *message,
   size_t length);

error_t sshParseKexDhGexMessage(SshConnection *connection, uint8_t type,
   const uint8_t *message, size_t length);

int_t sshSelectDhGexGroup(SshContext *context, uint32_t minDhModulusSize,
   uint32_t preferredDhModulusSize, uint32_t maxDhModulusSize);

error_t sshComputeDhGexSharedSecret(SshConnection *connection);

error_t sshDigestDhGexParams(SshConnection *connection);

//C++ guard
#ifdef __cplusplus
}
#endif

#endif
