/**
 * @file ssh_key_decrypt.h
 * @brief SSH private key decryption
 *
 * @section License
 *
 * Copyright (C) 2021-2026 Oryx Embedded SARL. All rights reserved.
 *
 * This file is part of CycloneSSH Eval
 * 
 * This software is provided in source form for a short-term evaluation only. The
 * evaluation license expires 90 days after the date you first download the software.
 *
 * If you plan to use this software in a commercial product, you are required to
 * purchase a commercial license from Oryx Embedded SARL.
 *
 * After the 90-day evaluation period, you agree to either purchase a commercial
 * license or delete all copies of this software. If you wish to extend the
 * evaluation period, you must contact sales@oryx-embedded.com.
 *
 * This evaluation software is provided "as is" without warranty of any kind.
 * Technical support is available as an option during the evaluation period.

 *
 * @author Oryx Embedded SARL (www.oryx-embedded.com)
 * @version 2.6.0
 **/

#ifndef _SSH_KEY_DECRYPT_H
#define _SSH_KEY_DECRYPT_H

//Dependencies
#include "ssh.h"
#include "ssh_key_parse.h"

//C++ guard
#ifdef __cplusplus
extern "C" {
#endif


/**
 * @brief KDF options
 **/

typedef struct
{
   SshBinaryString salt;
   uint32_t rounds;
} SshKdfOptions;


//SSH private key decryption related functions
error_t sshDecryptPrivateKey(const char_t *input, size_t inputLen,
   const char_t *password, char_t *output, size_t *outputLen);

error_t sshDecryptOpenSshPrivateKey(const SshPrivateKeyHeader *privateKeyHeader,
   const char_t *password, const uint8_t *ciphertext, uint8_t *plaintext,
   size_t length);

error_t sshParseKdfOptions(const uint8_t *data, size_t length,
   SshKdfOptions *kdfOptions);

error_t sshKdf(const char *password, size_t passwordLen, const uint8_t *salt,
   size_t saltLen, uint_t rounds, uint8_t *key, size_t keyLen);

error_t sshKdfHash(uint8_t *password, uint8_t *salt, uint8_t *output);

//C++ guard
#ifdef __cplusplus
}
#endif

#endif
