/**
 * @file ssh_key_format.h
 * @brief SSH key formatting
 *
 * @section License
 *
 * Copyright (C) 2021-2026 Oryx Embedded SARL. All rights reserved.
 *
 * This file is part of CycloneSSH Eval
 * 
 * This software is provided in source form for a short-term evaluation only. The
 * evaluation license expires 90 days after the date you first download the software.
 *
 * If you plan to use this software in a commercial product, you are required to
 * purchase a commercial license from Oryx Embedded SARL.
 *
 * After the 90-day evaluation period, you agree to either purchase a commercial
 * license or delete all copies of this software. If you wish to extend the
 * evaluation period, you must contact sales@oryx-embedded.com.
 *
 * This evaluation software is provided "as is" without warranty of any kind.
 * Technical support is available as an option during the evaluation period.

 *
 * @author Oryx Embedded SARL (www.oryx-embedded.com)
 * @version 2.6.0
 **/

#ifndef _SSH_KEY_FORMAT_H
#define _SSH_KEY_FORMAT_H

//Dependencies
#include "ssh_types.h"
#include "pkc/rsa.h"
#include "pkc/dsa.h"
#include "ecc/ec.h"
#include "ecc/eddsa.h"

//Helper macro
#define SSH_INC_POINTER(p, n) ((p != NULL) ? (p + n) : NULL)

//C++ guard
#ifdef __cplusplus
extern "C" {
#endif

//SSH key formatting functions
error_t sshFormatRsaPublicKey(const RsaPublicKey *publicKey,
   uint8_t *p, size_t *written);

error_t sshFormatDsaPublicKey(const DsaPublicKey *publicKey,
   uint8_t *p, size_t *written);

error_t sshFormatEcdsaPublicKey(const EcPublicKey *publicKey,
   uint8_t *p, size_t *written);

error_t sshFormatEd25519PublicKey(const EddsaPublicKey *publicKey,
   uint8_t *p, size_t *written);

error_t sshFormatEd448PublicKey(const EddsaPublicKey *publicKey,
   uint8_t *p, size_t *written);

error_t sshFormatOpenSshPrivateKeyHeader(uint8_t *p, size_t *written);

error_t sshFormatOpenSshRsaPrivateKey(const RsaPrivateKey *privateKey,
   uint8_t *p, size_t *written);

error_t sshFormatOpenSshDsaPrivateKey(const DsaPrivateKey *privateKey,
   uint8_t *p, size_t *written);

error_t sshFormatOpenSshEcdsaPrivateKey(const EcPrivateKey *privateKey,
   uint8_t *p, size_t *written);

error_t sshFormatOpenSshEd25519PrivateKey(const EddsaPrivateKey *privateKey,
   uint8_t *p, size_t *written);

error_t sshFormatOpenSshEd448PrivateKey(const EddsaPrivateKey *privateKey,
   uint8_t *p, size_t *written);

//C++ guard
#ifdef __cplusplus
}
#endif

#endif
