/**
 * @file ssh_key_material.h
 * @brief Key material generation
 *
 * @section License
 *
 * Copyright (C) 2021-2026 Oryx Embedded SARL. All rights reserved.
 *
 * This file is part of CycloneSSH Eval
 * 
 * This software is provided in source form for a short-term evaluation only. The
 * evaluation license expires 90 days after the date you first download the software.
 *
 * If you plan to use this software in a commercial product, you are required to
 * purchase a commercial license from Oryx Embedded SARL.
 *
 * After the 90-day evaluation period, you agree to either purchase a commercial
 * license or delete all copies of this software. If you wish to extend the
 * evaluation period, you must contact sales@oryx-embedded.com.
 *
 * This evaluation software is provided "as is" without warranty of any kind.
 * Technical support is available as an option during the evaluation period.

 *
 * @author Oryx Embedded SARL (www.oryx-embedded.com)
 * @version 2.6.0
 **/

#ifndef _SSH_KEY_MATERIAL_H
#define _SSH_KEY_MATERIAL_H

//Dependencies
#include "ssh/ssh.h"

//C++ guard
#ifdef __cplusplus
extern "C" {
#endif

//SSH related functions
error_t sshInitEncryptionEngine(SshConnection *connection,
   SshEncryptionEngine *encryptionEngine, const char_t *encAlgo,
   const char_t *macAlgo, uint8_t x);

void sshFreeEncryptionEngine(SshEncryptionEngine *encryptionEngine);

error_t sshSelectCipherAlgo(SshEncryptionEngine *encryptionEngine,
   const char_t *encAlgo);

error_t sshSelectHashAlgo(SshEncryptionEngine *encryptionEngine,
   const char_t *encAlgo, const char_t *macAlgo);

error_t sshDeriveKey(SshConnection *connection, uint8_t x, uint8_t *output,
   size_t outputLen);

void sshDumpKey(SshConnection *connection, const char_t *label,
   const uint8_t *key, size_t keyLen);

//C++ guard
#ifdef __cplusplus
}
#endif

#endif
