/**
 * @file ssh_key_verify.h
 * @brief SSH host key verification
 *
 * @section License
 *
 * Copyright (C) 2021-2026 Oryx Embedded SARL. All rights reserved.
 *
 * This file is part of CycloneSSH Eval
 * 
 * This software is provided in source form for a short-term evaluation only. The
 * evaluation license expires 90 days after the date you first download the software.
 *
 * If you plan to use this software in a commercial product, you are required to
 * purchase a commercial license from Oryx Embedded SARL.
 *
 * After the 90-day evaluation period, you agree to either purchase a commercial
 * license or delete all copies of this software. If you wish to extend the
 * evaluation period, you must contact sales@oryx-embedded.com.
 *
 * This evaluation software is provided "as is" without warranty of any kind.
 * Technical support is available as an option during the evaluation period.

 *
 * @author Oryx Embedded SARL (www.oryx-embedded.com)
 * @version 2.6.0
 **/

#ifndef _SSH_KEY_VERIFY_H
#define _SSH_KEY_VERIFY_H

//Dependencies
#include "ssh.h"

//C++ guard
#ifdef __cplusplus
extern "C" {
#endif

//SSH host key verification related functions
error_t sshVerifyHostKey(const uint8_t *hostKey, size_t hostKeyLen,
   const char_t *trustedKey, size_t trustedKeyLen);

error_t sshVerifyClientHostKey(SshConnection *connection,
   const SshString *publicKeyAlgo, const SshBinaryString *hostKey);

error_t sshVerifyServerHostKey(SshConnection *connection,
   const SshString *publicKeyAlgo, const SshBinaryString *hostKey);

//C++ guard
#ifdef __cplusplus
}
#endif

#endif
