/**
 * @file ssh_legacy.h
 * @brief Legacy definitions
 *
 * @section License
 *
 * Copyright (C) 2021-2026 Oryx Embedded SARL. All rights reserved.
 *
 * This file is part of CycloneSSH Eval
 * 
 * This software is provided in source form for a short-term evaluation only. The
 * evaluation license expires 90 days after the date you first download the software.
 *
 * If you plan to use this software in a commercial product, you are required to
 * purchase a commercial license from Oryx Embedded SARL.
 *
 * After the 90-day evaluation period, you agree to either purchase a commercial
 * license or delete all copies of this software. If you wish to extend the
 * evaluation period, you must contact sales@oryx-embedded.com.
 *
 * This evaluation software is provided "as is" without warranty of any kind.
 * Technical support is available as an option during the evaluation period.

 *
 * @author Oryx Embedded SARL (www.oryx-embedded.com)
 * @version 2.6.0
 **/

#ifndef _SSH_LEGACY_H
#define _SSH_LEGACY_H

//Deprecated definitions
#define SshClientConnection SshConnection
#define passwordCallback passwordAuthCallback
#define termWidthChar termWidthChars
#define termHeightChar termHeightRows
#define termWidthPixel termWidthPixels
#define termHeightPixel termHeightPixels

//Deprecated functions
#define sshServerSetTimeout sshSetChannelTimeout
#define sshServerWriteChannel sshWriteChannel
#define sshServerReadChannel sshReadChannel
#define sshServerTerminateChannel sshCloseChannel

#ifdef SSH_AES_SUPPORT
   #define SSH_AES_128_SUPPORT SSH_AES_SUPPORT
   #define SSH_AES_192_SUPPORT SSH_AES_SUPPORT
   #define SSH_AES_256_SUPPORT SSH_AES_SUPPORT
#endif

#ifdef SSH_CAMELLIA_SUPPORT
   #define SSH_CAMELLIA_128_SUPPORT SSH_CAMELLIA_SUPPORT
   #define SSH_CAMELLIA_192_SUPPORT SSH_CAMELLIA_SUPPORT
   #define SSH_CAMELLIA_256_SUPPORT SSH_CAMELLIA_SUPPORT
#endif

#define generateSignatureCallback signGenCallback

#ifdef SCP_SERVER_STACK_SIZE
   #define SCP_SERVER_TASK_STACK_SIZE SCP_SERVER_STACK_SIZE
#endif

#ifdef SCP_SERVER_PRIORITY
   #define SCP_SERVER_TASK_PRIORITY SCP_SERVER_PRIORITY
#endif

#ifdef SFTP_SERVER_STACK_SIZE
   #define SFTP_SERVER_TASK_STACK_SIZE SFTP_SERVER_STACK_SIZE
#endif

#ifdef SFTP_SERVER_PRIORITY
   #define SFTP_SERVER_TASK_PRIORITY SFTP_SERVER_PRIORITY
#endif

#ifdef SHELL_SERVER_STACK_SIZE
   #define SHELL_SERVER_TASK_STACK_SIZE SHELL_SERVER_STACK_SIZE
#endif

#ifdef SHELL_SERVER_PRIORITY
   #define SHELL_SERVER_TASK_PRIORITY SHELL_SERVER_PRIORITY
#endif

#ifdef SSH_SERVER_STACK_SIZE
   #define SSH_SERVER_TASK_STACK_SIZE SSH_SERVER_STACK_SIZE
#endif

#ifdef SSH_SERVER_PRIORITY
   #define SSH_SERVER_TASK_PRIORITY SSH_SERVER_PRIORITY
#endif

#define SshAccessStatus SshAuthStatus
#define SSH_ACCESS_DENIED SSH_AUTH_STATUS_FAILURE
#define SSH_ACCESS_ALLOWED SSH_AUTH_STATUS_SUCCESS

#define SshWindowChangeReqParams SshWindowChangeParams
#define sshParseWindowChangeReqParams sshParseWindowChangeParams

#ifdef SSH_DH_SUPPORT
   #define SSH_DH_KEX_SUPPORT SSH_DH_SUPPORT
#endif

#ifdef SSH_ECDH_SUPPORT
   #define SSH_ECDH_KEX_SUPPORT SSH_ECDH_SUPPORT
#endif

#ifdef SSH_RSA_SUPPORT
   #define SSH_RSA_SIGN_SUPPORT SSH_RSA_SUPPORT
#endif

#ifdef SSH_DSA_SUPPORT
   #define SSH_DSA_SIGN_SUPPORT SSH_DSA_SUPPORT
#endif

#ifdef SSH_ECDSA_SUPPORT
   #define SSH_ECDSA_SIGN_SUPPORT SSH_ECDSA_SUPPORT
#endif

#ifdef SSH_ED25519_SUPPORT
   #define SSH_ED25519_SIGN_SUPPORT SSH_ED25519_SUPPORT
#endif

#ifdef SSH_ED448_SUPPORT
   #define SSH_ED448_SIGN_SUPPORT SSH_ED448_SUPPORT
#endif

#endif
