/**
 * @file ssh_modp_groups.h
 * @brief Modular exponentiation (MODP) groups
 *
 * @section License
 *
 * Copyright (C) 2021-2026 Oryx Embedded SARL. All rights reserved.
 *
 * This file is part of CycloneSSH Eval
 * 
 * This software is provided in source form for a short-term evaluation only. The
 * evaluation license expires 90 days after the date you first download the software.
 *
 * If you plan to use this software in a commercial product, you are required to
 * purchase a commercial license from Oryx Embedded SARL.
 *
 * After the 90-day evaluation period, you agree to either purchase a commercial
 * license or delete all copies of this software. If you wish to extend the
 * evaluation period, you must contact sales@oryx-embedded.com.
 *
 * This evaluation software is provided "as is" without warranty of any kind.
 * Technical support is available as an option during the evaluation period.

 *
 * @author Oryx Embedded SARL (www.oryx-embedded.com)
 * @version 2.6.0
 **/

#ifndef _SSH_MODP_GROUPS_H
#define _SSH_MODP_GROUPS_H

//Dependencies
#include "ssh/ssh.h"
#include "pkc/dh.h"

//C++ guard
#ifdef __cplusplus
extern "C" {
#endif


/**
 * @brief Modular exponentiation (MODP) group
 **/

typedef struct
{
   const char_t *name;                           ///<Group name
   const uint8_t p[SSH_MAX_DH_MODULUS_SIZE / 8]; ///<Prime modulus
   size_t pLen;                                  ///<Length of the prime modulus, in bytes
   uint8_t g;                                    ///<Generator
} SshDhModpGroup;


//MODP groups
extern const SshDhModpGroup sshDhModpGroup1;
extern const SshDhModpGroup sshDhModpGroup14;
extern const SshDhModpGroup sshDhModpGroup15;
extern const SshDhModpGroup sshDhModpGroup16;
extern const SshDhModpGroup sshDhModpGroup17;
extern const SshDhModpGroup sshDhModpGroup18;

//MODP group related functions
const SshDhModpGroup *sshGetDhModpGroup(const char_t *kexAlgo);
error_t sshLoadDhModpGroup(DhParameters *params, const char_t *kexAlgo);

//C++ guard
#ifdef __cplusplus
}
#endif

#endif
