/**
 * @file ssh_packet.h
 * @brief SSH packet encryption/decryption
 *
 * @section License
 *
 * Copyright (C) 2021-2026 Oryx Embedded SARL. All rights reserved.
 *
 * This file is part of CycloneSSH Eval
 * 
 * This software is provided in source form for a short-term evaluation only. The
 * evaluation license expires 90 days after the date you first download the software.
 *
 * If you plan to use this software in a commercial product, you are required to
 * purchase a commercial license from Oryx Embedded SARL.
 *
 * After the 90-day evaluation period, you agree to either purchase a commercial
 * license or delete all copies of this software. If you wish to extend the
 * evaluation period, you must contact sales@oryx-embedded.com.
 *
 * This evaluation software is provided "as is" without warranty of any kind.
 * Technical support is available as an option during the evaluation period.

 *
 * @author Oryx Embedded SARL (www.oryx-embedded.com)
 * @version 2.6.0
 **/

#ifndef _SSH_PACKET_H
#define _SSH_PACKET_H

//Dependencies
#include "ssh/ssh.h"

//SSH packet header size
#define SSH_PACKET_HEADER_SIZE 5
//Minimum SSH packet size
#define SSH_MIN_PACKET_SIZE 8
//Default maximum packet size
#define SSH_DEFAULT_MAX_PACKET_SIZE 32768
//Size of SSH_MSG_CHANNEL_DATA message header
#define SSH_CHANNEL_DATA_MSG_HEADER_SIZE 9

//C++ guard
#ifdef __cplusplus
extern "C" {
#endif

//SSH related functions
error_t sshSendPacket(SshConnection *connection, uint8_t *payload,
   size_t payloadLen);

error_t sshReceivePacket(SshConnection *connection);

error_t sshParsePacket(SshConnection *connection, uint8_t *packet,
   size_t length);

error_t sshEncryptPacket(SshConnection *connection, uint8_t *packet,
   size_t *length);

error_t sshDecryptPacket(SshConnection *connection, uint8_t *packet,
   size_t *length);

error_t sshParsePacketLength(SshConnection *connection, uint8_t *packet);
error_t sshDecryptPacketLength(SshConnection *connection, uint8_t *packet);

error_t sshParseMessage(SshConnection *connection, const uint8_t *message,
   size_t length);

void sshAppendMessageAuthCode(SshEncryptionEngine *encryptionEngine,
   uint8_t *packet, size_t length);

error_t sshVerifyMessageAuthCode(SshEncryptionEngine *decryptionEngine,
   const uint8_t *packet, size_t length);

void sshIncSequenceNumber(uint8_t *seqNum);
void sshIncInvocationCounter(uint8_t *iv);

//C++ guard
#ifdef __cplusplus
}
#endif

#endif
