/**
 * @file ssh_transport.h
 * @brief SSH transport layer protocol
 *
 * @section License
 *
 * Copyright (C) 2021-2026 Oryx Embedded SARL. All rights reserved.
 *
 * This file is part of CycloneSSH Eval
 * 
 * This software is provided in source form for a short-term evaluation only. The
 * evaluation license expires 90 days after the date you first download the software.
 *
 * If you plan to use this software in a commercial product, you are required to
 * purchase a commercial license from Oryx Embedded SARL.
 *
 * After the 90-day evaluation period, you agree to either purchase a commercial
 * license or delete all copies of this software. If you wish to extend the
 * evaluation period, you must contact sales@oryx-embedded.com.
 *
 * This evaluation software is provided "as is" without warranty of any kind.
 * Technical support is available as an option during the evaluation period.

 *
 * @author Oryx Embedded SARL (www.oryx-embedded.com)
 * @version 2.6.0
 **/

#ifndef _SSH_TRANSPORT_H
#define _SSH_TRANSPORT_H

//Dependencies
#include "ssh/ssh.h"

//C++ guard
#ifdef __cplusplus
extern "C" {
#endif

//SSH related functions
error_t sshSendIdString(SshConnection *connection);
error_t sshSendServiceRequest(SshConnection *connection);

error_t sshSendServiceAccept(SshConnection *connection,
   const char_t *serviceName);

error_t sshSendDisconnect(SshConnection *connection,
   uint32_t reasonCode, const char_t *description);

error_t sshSendUnimplemented(SshConnection *connection,
   const uint8_t *packetSeqNum);

error_t sshFormatServiceRequest(SshConnection *connection, uint8_t *p,
   size_t *length);

error_t sshFormatServiceAccept(SshConnection *connection,
   const char_t *serviceName, uint8_t *p, size_t *length);

error_t sshFormatDisconnect(SshConnection *connection, uint32_t reasonCode,
   const char_t *description, uint8_t *p, size_t *length);

error_t sshFormatUnimplemented(SshConnection *connection,
   const uint8_t *packetSeqNum, uint8_t *p, size_t *length);

error_t sshParseIdString(SshConnection *connection, const uint8_t *id,
   size_t length);

error_t sshParseServiceRequest(SshConnection *connection, const uint8_t *message,
   size_t length);

error_t sshParseServiceAccept(SshConnection *connection, const uint8_t *message,
   size_t length);

error_t sshParseIgnore(SshConnection *connection, const uint8_t *message,
   size_t length);

error_t sshParseDebug(SshConnection *connection, const uint8_t *message,
   size_t length);

error_t sshParseDisconnect(SshConnection *connection, const uint8_t *message,
   size_t length);

error_t sshParseUnimplemented(SshConnection *connection, const uint8_t *message,
   size_t length);

error_t sshParseUnrecognized(SshConnection *connection, const uint8_t *message,
   size_t length);

//C++ guard
#ifdef __cplusplus
}
#endif

#endif
