/**
 * @file ssh_types.h
 * @brief SSH data type representations
 *
 * @section License
 *
 * Copyright (C) 2021-2026 Oryx Embedded SARL. All rights reserved.
 *
 * This file is part of CycloneSSH Eval
 * 
 * This software is provided in source form for a short-term evaluation only. The
 * evaluation license expires 90 days after the date you first download the software.
 *
 * If you plan to use this software in a commercial product, you are required to
 * purchase a commercial license from Oryx Embedded SARL.
 *
 * After the 90-day evaluation period, you agree to either purchase a commercial
 * license or delete all copies of this software. If you wish to extend the
 * evaluation period, you must contact sales@oryx-embedded.com.
 *
 * This evaluation software is provided "as is" without warranty of any kind.
 * Technical support is available as an option during the evaluation period.

 *
 * @author Oryx Embedded SARL (www.oryx-embedded.com)
 * @version 2.6.0
 **/

#ifndef _SSH_TYPES_H
#define _SSH_TYPES_H

//Dependencies
#include "compiler_port.h"
#include "error.h"

//C++ guard
#ifdef __cplusplus
extern "C" {
#endif


/**
 * @brief Boolean
 **/

typedef bool_t SshBoolean;


/**
 * @brief String
 **/

typedef struct
{
   const char_t *value;
   size_t length;
} SshString;


/**
 * @brief Binary string
 **/

typedef struct
{
   const uint8_t *value;
   size_t length;
} SshBinaryString;


/**
 * @brief String containing a comma-separated list of names
 **/

typedef struct
{
   const char_t *value;
   size_t length;
} SshNameList;


//C++ guard
#ifdef __cplusplus
}
#endif

#endif
