/**
 * @file tls_quic_misc.h
 * @brief QUIC helper functions
 *
 * @section License
 *
 * Copyright (C) 2021-2026 Oryx Embedded SARL. All rights reserved.
 *
 * This file is part of CycloneSSL Eval
 * 
 * This software is provided in source form for a short-term evaluation only. The
 * evaluation license expires 90 days after the date you first download the software.
 *
 * If you plan to use this software in a commercial product, you are required to
 * purchase a commercial license from Oryx Embedded SARL.
 *
 * After the 90-day evaluation period, you agree to either purchase a commercial
 * license or delete all copies of this software. If you wish to extend the
 * evaluation period, you must contact sales@oryx-embedded.com.
 *
 * This evaluation software is provided "as is" without warranty of any kind.
 * Technical support is available as an option during the evaluation period.

 *
 * @author Oryx Embedded SARL (www.oryx-embedded.com)
 * @version 2.6.0
 **/

#ifndef _TLS_QUIC_MISC_H
#define _TLS_QUIC_MISC_H

//Dependencies
#include "tls.h"

//C++ guard
#ifdef __cplusplus
extern "C" {
#endif

//QUIC TLS related functions
error_t tlsFormatQuicTransportParamsExtension(TlsContext *context,
   uint8_t *p, size_t *written);

error_t tlsParseQuicTransportParamsExtension(TlsContext *context,
   const TlsExtension *quicTransportParams);

error_t tlsSetQuicEncryptionKeys(TlsContext *context, TlsEncryptionLevel level,
   const uint8_t *clientKey, const uint8_t *serverKey, size_t keyLen);

error_t tlsSendQuicHandshakeMessage(TlsContext *context, const uint8_t *message,
   size_t length);

error_t tlsSendQuicAlertMessage(TlsContext *context, const TlsAlert *message,
   size_t length);

//C++ guard
#ifdef __cplusplus
}
#endif

#endif
