/**
 * @file tls_sign_generate.h
 * @brief RSA/DSA/ECDSA/EdDSA signature generation
 *
 * @section License
 *
 * Copyright (C) 2021-2026 Oryx Embedded SARL. All rights reserved.
 *
 * This file is part of CycloneSSL Eval
 * 
 * This software is provided in source form for a short-term evaluation only. The
 * evaluation license expires 90 days after the date you first download the software.
 *
 * If you plan to use this software in a commercial product, you are required to
 * purchase a commercial license from Oryx Embedded SARL.
 *
 * After the 90-day evaluation period, you agree to either purchase a commercial
 * license or delete all copies of this software. If you wish to extend the
 * evaluation period, you must contact sales@oryx-embedded.com.
 *
 * This evaluation software is provided "as is" without warranty of any kind.
 * Technical support is available as an option during the evaluation period.

 *
 * @author Oryx Embedded SARL (www.oryx-embedded.com)
 * @version 2.6.0
 **/

#ifndef _TLS_SIGN_GENERATE_H
#define _TLS_SIGN_GENERATE_H

//Dependencies
#include "tls.h"

//C++ guard
#ifdef __cplusplus
extern "C" {
#endif

//TLS related functions
error_t tlsGenerateSignature(TlsContext *context, uint8_t *p,
   size_t *length);

error_t tls12GenerateSignature(TlsContext *context, uint8_t *p,
   size_t *length);

error_t tlsGenerateRsaSignature(const RsaPrivateKey *key,
   const uint8_t *digest, uint8_t *signature, size_t *signatureLen);

error_t tlsGenerateRsaPkcs1Signature(TlsContext *context,
   const HashAlgo *hashAlgo, const uint8_t *digest, uint8_t *signature,
   size_t *signatureLen);

error_t tlsGenerateRsaPssSignature(TlsContext *context,
   const HashAlgo *hashAlgo, const uint8_t *digest, uint8_t *signature,
   size_t *signatureLen);

error_t tlsGenerateDsaSignature(TlsContext *context, const uint8_t *digest,
   size_t digestLen, uint8_t *signature, size_t *signatureLen);

error_t tlsGenerateEcdsaSignature(TlsContext *context, const uint8_t *digest,
   size_t digestLen, uint8_t *signature, size_t *signatureLen);

error_t tlsGenerateEd25519Signature(TlsContext *context,
   const DataChunk *message, uint_t messageLen, uint8_t *signature,
   size_t *signatureLen);

error_t tlsGenerateEd448Signature(TlsContext *context,
   const DataChunk *message, uint_t messageLen, uint8_t *signature,
   size_t *signatureLen);

//C++ guard
#ifdef __cplusplus
}
#endif

#endif
