/**
 * @file tls_sign_misc.h
 * @brief Helper functions for signature generation and verification
 *
 * @section License
 *
 * Copyright (C) 2021-2026 Oryx Embedded SARL. All rights reserved.
 *
 * This file is part of CycloneSSL Eval
 * 
 * This software is provided in source form for a short-term evaluation only. The
 * evaluation license expires 90 days after the date you first download the software.
 *
 * If you plan to use this software in a commercial product, you are required to
 * purchase a commercial license from Oryx Embedded SARL.
 *
 * After the 90-day evaluation period, you agree to either purchase a commercial
 * license or delete all copies of this software. If you wish to extend the
 * evaluation period, you must contact sales@oryx-embedded.com.
 *
 * This evaluation software is provided "as is" without warranty of any kind.
 * Technical support is available as an option during the evaluation period.

 *
 * @author Oryx Embedded SARL (www.oryx-embedded.com)
 * @version 2.6.0
 **/

#ifndef _TLS_SIGN_MISC_H
#define _TLS_SIGN_MISC_H

//Dependencies
#include "tls.h"

//Extract signature algorithm from legacy signature scheme
#define TLS_SIGN_ALGO(signScheme) ((TlsSignatureAlgo) LSB(signScheme))

//Extract hash algorithm from legacy signature scheme
#define TLS_HASH_ALGO(signScheme) ((TlsHashAlgo) MSB(signScheme))

//C++ guard
#ifdef __cplusplus
extern "C" {
#endif

//TLS related functions
error_t tlsSelectSignAlgo(TlsContext *context, const TlsCertDesc *cert,
   const TlsSignSchemeList *signAlgoList);

error_t tlsFormatSignAlgosExtension(TlsContext *context, uint8_t *p,
   size_t *written);

error_t tlsFormatSignAlgosCertExtension(TlsContext *context,
   uint8_t *p, size_t *written);

error_t tlsFormatSupportedSignAlgos(TlsContext *context, uint8_t *p,
   size_t *written);

bool_t tlsIsSignAlgoOffered(uint16_t signScheme,
   const TlsSignSchemeList *signSchemeList);

bool_t tlsIsSignAlgoAcceptable(TlsContext *context, uint16_t signScheme,
   const TlsCertDesc *cert);

bool_t tlsIsSignAlgoSupported(TlsContext *context, uint16_t signScheme);
bool_t tlsIsCertSignAlgoSupported(uint16_t signScheme);

//C++ guard
#ifdef __cplusplus
}
#endif

#endif
