/**
 * @file igmp_debug.h
 * @brief Data logging functions for debugging purpose (IGMP)
 *
 * @section License
 *
 * Copyright (C) 2021-2026 Oryx Embedded SARL. All rights reserved.
 *
 * This file is part of CycloneTCP Eval
 * 
 * This software is provided in source form for a short-term evaluation only. The
 * evaluation license expires 90 days after the date you first download the software.
 *
 * If you plan to use this software in a commercial product, you are required to
 * purchase a commercial license from Oryx Embedded SARL.
 *
 * After the 90-day evaluation period, you agree to either purchase a commercial
 * license or delete all copies of this software. If you wish to extend the
 * evaluation period, you must contact sales@oryx-embedded.com.
 *
 * This evaluation software is provided "as is" without warranty of any kind.
 * Technical support is available as an option during the evaluation period.

 *
 * @author Oryx Embedded SARL (www.oryx-embedded.com)
 * @version 2.6.0
 **/

#ifndef _IGMP_DEBUG_H
#define _IGMP_DEBUG_H

//Dependencies
#include "core/net.h"
#include "igmp/igmp_common.h"
#include "debug.h"

//C++ guard
#ifdef __cplusplus
extern "C" {
#endif


/**
 * @brief Parameter value/name binding
 **/

typedef struct
{
   uint_t value;
   const char_t *name;
} IgmpParamName;


//Check current trace level
#if (IGMP_TRACE_LEVEL >= TRACE_LEVEL_DEBUG)
   void igmpDumpMessage(const IgmpMessage *message, size_t length);
#else
   #define igmpDumpMessage(message, length)
#endif

void igmpDumpMembershipQueryV3(const IgmpMembershipQueryV3 *message,
   size_t length);

void igmpDumpMessageMembershipReportV3(const IgmpMembershipReportV3 *message,
   size_t length);

void igmpDumpGroupRecord(const IgmpGroupRecord *record,
   size_t length);

const char_t *igmpGetParamName(uint_t value, const IgmpParamName *paramList,
   size_t paramListLen);

//C++ guard
#ifdef __cplusplus
}
#endif

#endif
