/**
 * @file ipv4_multicast.h
 * @brief IPv4 multicast filtering
 *
 * @section License
 *
 * Copyright (C) 2021-2026 Oryx Embedded SARL. All rights reserved.
 *
 * This file is part of CycloneTCP Eval
 * 
 * This software is provided in source form for a short-term evaluation only. The
 * evaluation license expires 90 days after the date you first download the software.
 *
 * If you plan to use this software in a commercial product, you are required to
 * purchase a commercial license from Oryx Embedded SARL.
 *
 * After the 90-day evaluation period, you agree to either purchase a commercial
 * license or delete all copies of this software. If you wish to extend the
 * evaluation period, you must contact sales@oryx-embedded.com.
 *
 * This evaluation software is provided "as is" without warranty of any kind.
 * Technical support is available as an option during the evaluation period.

 *
 * @author Oryx Embedded SARL (www.oryx-embedded.com)
 * @version 2.6.0
 **/

#ifndef _IPV4_MULTICAST_H
#define _IPV4_MULTICAST_H

//Dependencies
#include "core/net.h"
#include "ipv4/ipv4.h"

//C++ guard
#ifdef __cplusplus
extern "C" {
#endif

//IPv4 multicast related functions
error_t ipv4MulticastFilter(NetInterface *interface, Ipv4Addr destAddr,
   Ipv4Addr srcAddr);

error_t ipv4JoinMulticastGroup(NetInterface *interface, Ipv4Addr groupAddr);
error_t ipv4LeaveMulticastGroup(NetInterface *interface, Ipv4Addr groupAddr);

void ipv4UpdateMulticastFilter(NetInterface *interface, Ipv4Addr groupAddr);

void ipv4DeriveInterfaceState(Ipv4FilterEntry *entry,
   SocketMulticastGroup *group);

error_t ipv4AcceptMulticastAddr(NetInterface *interface, Ipv4Addr groupAddr);
void ipv4DropMulticastAddr(NetInterface *interface, Ipv4Addr groupAddr);

error_t ipv4MapMulticastAddrToMac(Ipv4Addr ipAddr, MacAddr *macAddr);

Ipv4FilterEntry *ipv4CreateMulticastFilterEntry(NetInterface *interface,
   Ipv4Addr multicastAddr);

Ipv4FilterEntry *ipv4FindMulticastFilterEntry(NetInterface *interface,
   Ipv4Addr multicastAddr);

void ipv4DeleteMulticastFilterEntry(Ipv4FilterEntry *entry);

error_t ipv4AddSrcAddr(Ipv4SrcAddrList *list, Ipv4Addr srcAddr);
void ipv4RemoveSrcAddr(Ipv4SrcAddrList *list, Ipv4Addr srcAddr);
int_t ipv4FindSrcAddr(const Ipv4SrcAddrList *list, Ipv4Addr srcAddr);

bool_t ipv4CompareSrcAddrLists(const Ipv4SrcAddrList *list1,
   const Ipv4SrcAddrList *list2);

//C++ guard
#ifdef __cplusplus
}
#endif

#endif
