/**
 * @file ipv6_multicast.h
 * @brief IPv6 multicast filtering
 *
 * @section License
 *
 * Copyright (C) 2021-2026 Oryx Embedded SARL. All rights reserved.
 *
 * This file is part of CycloneTCP Eval
 * 
 * This software is provided in source form for a short-term evaluation only. The
 * evaluation license expires 90 days after the date you first download the software.
 *
 * If you plan to use this software in a commercial product, you are required to
 * purchase a commercial license from Oryx Embedded SARL.
 *
 * After the 90-day evaluation period, you agree to either purchase a commercial
 * license or delete all copies of this software. If you wish to extend the
 * evaluation period, you must contact sales@oryx-embedded.com.
 *
 * This evaluation software is provided "as is" without warranty of any kind.
 * Technical support is available as an option during the evaluation period.

 *
 * @author Oryx Embedded SARL (www.oryx-embedded.com)
 * @version 2.6.0
 **/

#ifndef _IPV6_MULTICAST_H
#define _IPV6_MULTICAST_H

//Dependencies
#include "core/net.h"
#include "ipv6/ipv6.h"

//C++ guard
#ifdef __cplusplus
extern "C" {
#endif

//IPv6 multicast related functions
error_t ipv6MulticastFilter(NetInterface *interface, const Ipv6Addr *destAddr,
   const Ipv6Addr *srcAddr);

error_t ipv6JoinMulticastGroup(NetInterface *interface,
   const Ipv6Addr *groupAddr);

error_t ipv6LeaveMulticastGroup(NetInterface *interface,
   const Ipv6Addr *groupAddr);

void ipv6UpdateMulticastFilter(NetInterface *interface,
   const Ipv6Addr *groupAddr);

void ipv6DeriveInterfaceState(Ipv6FilterEntry *entry,
   SocketMulticastGroup *group);

error_t ipv6AcceptMulticastAddr(NetInterface *interface,
   const Ipv6Addr *groupAddr);

void ipv6DropMulticastAddr(NetInterface *interface,
   const Ipv6Addr *groupAddr);

error_t ipv6MapMulticastAddrToMac(const Ipv6Addr *ipAddr, MacAddr *macAddr);

Ipv6FilterEntry *ipv6CreateMulticastFilterEntry(NetInterface *interface,
   const Ipv6Addr *multicastAddr);

Ipv6FilterEntry *ipv6FindMulticastFilterEntry(NetInterface *interface,
   const Ipv6Addr *multicastAddr);

void ipv6DeleteMulticastFilterEntry(Ipv6FilterEntry *entry);

error_t ipv6AddSrcAddr(Ipv6SrcAddrList *list, const Ipv6Addr *srcAddr);
void ipv6RemoveSrcAddr(Ipv6SrcAddrList *list, const Ipv6Addr *srcAddr);
int_t ipv6FindSrcAddr(const Ipv6SrcAddrList *list, const Ipv6Addr *srcAddr);

bool_t ipv6CompareSrcAddrLists(const Ipv6SrcAddrList *list1,
   const Ipv6SrcAddrList *list2);

//C++ guard
#ifdef __cplusplus
}
#endif

#endif
