/**
 * @file mld_debug.h
 * @brief Data logging functions for debugging purpose (MLD)
 *
 * @section License
 *
 * Copyright (C) 2021-2026 Oryx Embedded SARL. All rights reserved.
 *
 * This file is part of CycloneTCP Eval
 * 
 * This software is provided in source form for a short-term evaluation only. The
 * evaluation license expires 90 days after the date you first download the software.
 *
 * If you plan to use this software in a commercial product, you are required to
 * purchase a commercial license from Oryx Embedded SARL.
 *
 * After the 90-day evaluation period, you agree to either purchase a commercial
 * license or delete all copies of this software. If you wish to extend the
 * evaluation period, you must contact sales@oryx-embedded.com.
 *
 * This evaluation software is provided "as is" without warranty of any kind.
 * Technical support is available as an option during the evaluation period.

 *
 * @author Oryx Embedded SARL (www.oryx-embedded.com)
 * @version 2.6.0
 **/

#ifndef _MLD_DEBUG_H
#define _MLD_DEBUG_H

//Dependencies
#include "core/net.h"
#include "mld/mld_common.h"
#include "debug.h"

//C++ guard
#ifdef __cplusplus
extern "C" {
#endif


/**
 * @brief Parameter value/name binding
 **/

typedef struct
{
   uint_t value;
   const char_t *name;
} MldParamName;


//Check current trace level
#if (MLD_TRACE_LEVEL >= TRACE_LEVEL_DEBUG)
   void mldDumpMessage(const MldMessage *message, size_t length);
#else
   #define mldDumpMessage(message, length)
#endif

void mldDumpQueryV2(const MldListenerQueryV2 *message, size_t length);
void mldDumpReportV2(const MldListenerReportV2 *message, size_t length);

void mldDumpMulticastAddrRecord(const MldMcastAddrRecord *record,
   size_t length);

const char_t *mldGetParamName(uint_t value, const MldParamName *paramList,
   size_t paramListLen);

//C++ guard
#ifdef __cplusplus
}
#endif

#endif
