/**
 * @file mld_node_misc.h
 * @brief Helper functions for MLD node
 *
 * @section License
 *
 * Copyright (C) 2021-2026 Oryx Embedded SARL. All rights reserved.
 *
 * This file is part of CycloneTCP Eval
 * 
 * This software is provided in source form for a short-term evaluation only. The
 * evaluation license expires 90 days after the date you first download the software.
 *
 * If you plan to use this software in a commercial product, you are required to
 * purchase a commercial license from Oryx Embedded SARL.
 *
 * After the 90-day evaluation period, you agree to either purchase a commercial
 * license or delete all copies of this software. If you wish to extend the
 * evaluation period, you must contact sales@oryx-embedded.com.
 *
 * This evaluation software is provided "as is" without warranty of any kind.
 * Technical support is available as an option during the evaluation period.

 *
 * @author Oryx Embedded SARL (www.oryx-embedded.com)
 * @version 2.6.0
 **/

#ifndef _MLD_NODE_MISC_H
#define _MLD_NODE_MISC_H

//Dependencies
#include "core/net.h"
#include "mld/mld_node.h"

//C++ guard
#ifdef __cplusplus
extern "C" {
#endif

//MLD node related functions
void mldNodeChangeCompatibilityMode(MldNodeContext *context,
   MldVersion compatibilityMode);

void mldNodeSendUnsolicitedReport(MldNodeContext *context,
   const Ipv6Addr *groupAddr);

void mldNodeSendListenerReport(MldNodeContext *context,
   const Ipv6Addr *groupAddr);

void mldNodeSendListenerDone(MldNodeContext *context,
   const Ipv6Addr *groupAddr);

void mldNodeSendCurrentStateReport(MldNodeContext *context,
   const Ipv6Addr *groupAddr);

void mldNodeSendStateChangeReport(MldNodeContext *context,
   const Ipv6Addr *groupAddr);

void mldNodeFlushReportRecords(MldNodeContext *context, NetBuffer *buffer,
   size_t offset, size_t *length);

void mldNodeProcessMessage(MldNodeContext *context,
   const Ipv6PseudoHeader *pseudoHeader, const MldMessage *message,
   size_t length);

void mldNodeProcessListenerQuery(MldNodeContext *context,
   const Ipv6PseudoHeader *pseudoHeader, const MldMessage *message,
   size_t length);

void mldNodeProcessListenerQueryV2(MldNodeContext *context,
   const Ipv6PseudoHeader *pseudoHeader, const MldListenerQueryV2 *message,
   size_t length);

void mldNodeProcessListenerReport(MldNodeContext *context,
   const Ipv6PseudoHeader *pseudoHeader, const MldMessage *message,
   size_t length);

void mldNodeMergeReports(MldNodeGroup *group,
   IpFilterMode newFilterMode, const Ipv6SrcAddrList *newFilter);

bool_t mldNodeGetRetransmitStatus(MldNodeContext *context);
bool_t mldNodeGetGroupRetransmitStatus(MldNodeGroup *group);
void mldNodeDecGroupRetransmitCounters(MldNodeGroup *group);

MldNodeGroup *mldNodeCreateGroup(MldNodeContext *context,
   const Ipv6Addr *groupAddr);

MldNodeGroup *mldNodeFindGroup(MldNodeContext *context,
   const Ipv6Addr *groupAddr);

bool_t mldNodeMatchGroup(MldNodeGroup *group, const Ipv6Addr *multicastAddr);
void mldNodeDeleteGroup(MldNodeGroup *group);
void mldNodeFlushUnusedGroups(MldNodeContext *context);

error_t mldNodeAddSrcAddr(MldNodeSrcAddrList *list, const Ipv6Addr *srcAddr);
void mldNodeRemoveSrcAddr(MldNodeSrcAddrList *list, const Ipv6Addr *srcAddr);

int_t mldNodeFindSrcAddr(const MldNodeSrcAddrList *list,
   const Ipv6Addr *srcAddr);

//C++ guard
#ifdef __cplusplus
}
#endif

#endif
